/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprWalker;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.expr.VarsVisitor;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import java.util.Collection;

public abstract class ExprNode
implements Expr,
Constraint {
    public boolean isSatisfied(Binding binding, ExecutionContext execCxt) {
        try {
            NodeValue v = this.eval(binding, execCxt);
            boolean b = Functions.effectiveBooleanValue(v);
            return b;
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    public boolean isExpr() {
        return true;
    }

    public final Expr getExpr() {
        return this;
    }

    public abstract NodeValue eval(Binding var1, ExecutionContext var2);

    public void varsMentioned(Collection acc) {
        VarsVisitor vv = new VarsVisitor(acc);
        ExprWalker.walk(vv, this);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean isVariable() {
        return false;
    }

    public String getVarName() {
        return null;
    }

    public NodeVar getVar() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public NodeValue getConstant() {
        return null;
    }

    public String toString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        FmtExprARQ v = new FmtExprARQ(buff.getIndentedWriter(), null);
        this.visit(v);
        return buff.toString();
    }
}

