/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.QueryIterConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BindingImmutable
extends Binding {
    List vars;
    List values;
    private int calcHashCode;

    public BindingImmutable(Collection projectVars, Binding original) {
        super(null);
        this.vars = new ArrayList(projectVars);
        this.values = new ArrayList(projectVars.size());
        this.calcHashCode = 0;
        Iterator iter = projectVars.iterator();
        while (iter.hasNext()) {
            String varName = (String)iter.next();
            Node n = original.get(varName);
            this.vars.add(varName);
            this.values.add(n);
            if (n == null) continue;
            this.calcHashCode = this.calcHashCode ^ n.hashCode() ^ varName.hashCode();
        }
    }

    protected void add1(String name, Node node) {
        throw new UnsupportedOperationException("BindingImmutable.add");
    }

    protected Iterator names1() {
        return this.vars.listIterator();
    }

    protected boolean contains1(String name) {
        Node tmp = this.get1(name);
        return tmp != null;
    }

    protected Node get1(String name) {
        int i = this.vars.indexOf(name);
        if (i < 0) {
            return null;
        }
        return (Node)this.values.get(i);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BindingImmutable)) {
            return false;
        }
        BindingImmutable b = (BindingImmutable)obj;
        if (b.hashCode() != this.hashCode()) {
            return false;
        }
        if (this.vars.size() != b.vars.size()) {
            return false;
        }
        ListIterator iter = this.vars.listIterator();
        while (iter.hasNext()) {
            String varName = (String)iter.next();
            Node obj1 = this.get(varName);
            Node obj2 = b.get(varName);
            if (obj1 == null && obj2 == null) continue;
            if (obj1 == null) {
                return false;
            }
            if (obj2 == null) {
                return false;
            }
            if (obj1.equals(obj2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.calcHashCode;
    }

    protected void checkAdd1(String vn, Node node) {
    }

    public static QueryIterator makeConverterIterator(Collection vars, QueryIterator cIter, ExecutionContext context) {
        return new QueryIterConvert(cIter, new Convert(vars), context);
    }

    public static class Convert
    implements QueryIterConvert.Converter {
        Collection vars;

        public Convert(Collection vars) {
            this.vars = vars;
        }

        public Binding convert(Binding binding) {
            return new BindingImmutable(this.vars, binding);
        }
    }
}

