/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.BindingRoot;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Binding {
    static Log log = LogFactory.getLog((Class)Binding.class);
    static boolean CHECKING = true;
    static boolean UNIQUE_NAMES_CHECK = true;
    Binding parent;
    List children = new ArrayList();

    protected Binding(Binding _parent) {
        this.parent = _parent;
    }

    public static BindingRoot createRootBinding() {
        return new BindingRoot();
    }

    public Iterator getChildren() {
        return this.children.listIterator();
    }

    public Binding getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return false;
    }

    public Binding getRootBinding() {
        if (this.isRoot()) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getRootBinding();
        }
        return null;
    }

    private void addChild(Binding child) {
        this.children.add(child);
    }

    public void add(String name, Node node) {
        if (node == null) {
            log.warn((Object)"Binding.add: null value - ignored");
            return;
        }
        this.checkAdd(name, node);
        this.add1(name, node);
    }

    protected abstract void add1(String var1, Node var2);

    public Iterator names() {
        Iterator iter = this.names1();
        if (this.parent != null) {
            iter = new ConcatenatedIterator(this.parent.names(), iter);
        }
        return iter;
    }

    protected abstract Iterator names1();

    public boolean contains(String name) {
        if (this.contains1(name)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(name);
    }

    protected abstract boolean contains1(String var1);

    public Node get(String name) {
        Node node = this.get1(name);
        if (node != null) {
            return node;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(name);
    }

    protected abstract Node get1(String var1);

    public String toString() {
        String tmp;
        StringBuffer sbuff = new StringBuffer();
        this.format1(sbuff);
        if (this.parent != null && (tmp = this.parent.toString()) != null && tmp.length() != 0) {
            sbuff.append(" -> ");
            sbuff.append(tmp);
        }
        return sbuff.toString();
    }

    public void format1(StringBuffer sbuff) {
        String sep = "";
        Iterator iter = this.names1();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sbuff.append(sep);
            sep = " ";
            Node obj = this.get(name);
            String tmp = FmtUtils.stringForObject(obj);
            sbuff.append("( ?" + name + " = " + tmp + " )");
        }
    }

    public String toString1() {
        StringBuffer sbuff = new StringBuffer();
        this.format1(sbuff);
        return sbuff.toString();
    }

    private void checkAdd(String vn, Node node) {
        if (!CHECKING) {
            return;
        }
        if (node == null) {
            log.warn((Object)("check(" + vn + ", " + node + "): null node value"));
        }
        if (UNIQUE_NAMES_CHECK && this.get(vn) != null) {
            log.warn((Object)("check(" + vn + ", " + node + "): Duplicate variable: " + vn));
        }
        this.checkAdd1(vn, node);
    }

    protected abstract void checkAdd1(String var1, Node var2);

    public static boolean same(Binding bind1, Binding bind2) {
        Iterator iter1 = bind1.names();
        while (iter1.hasNext()) {
            String varName = (String)iter1.next();
            Node n1 = bind1.get(varName);
            Node n2 = bind2.get(varName);
            if (n1 == null && n2 == null) continue;
            if (n1 == null) {
                return false;
            }
            if (n2 == null) {
                return false;
            }
            if (n1.equals((Object)n2)) continue;
            return false;
        }
        Iterator iter2 = bind2.names();
        while (iter2.hasNext()) {
            String varName = (String)iter1.next();
            if (bind1.contains(varName)) continue;
            return false;
        }
        return true;
    }
}

