/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.util.ExprUtils;
import java.io.PrintStream;

public class qexpr {
    public static void main(String[] stringArray) {
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        cmdLineArgs.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "v", "verbose");
        cmdLineArgs.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "ver", "version", "V");
        cmdLineArgs.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(false, "q", "quiet");
        cmdLineArgs.add(argDecl4);
        ArgDecl argDecl5 = new ArgDecl(false, "n", "noExec", "noexec");
        cmdLineArgs.add(argDecl5);
        try {
            cmdLineArgs.process();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            qexpr.usage(System.err);
            System.exit(2);
        }
        if (cmdLineArgs.contains(argDecl)) {
            qexpr.usage();
            System.exit(0);
        }
        if (cmdLineArgs.contains(argDecl3)) {
            System.out.println("ARQ Version: 1.3 (Jena: 2.4-dev)");
            System.exit(0);
        }
        boolean bl = cmdLineArgs.contains(argDecl2);
        boolean bl2 = cmdLineArgs.contains(argDecl4);
        for (int i = 0; i < cmdLineArgs.getNumPositional(); ++i) {
            String string = cmdLineArgs.getPositionalArg(i);
            string = cmdLineArgs.indirect(string);
            try {
                Expr expr = ExprUtils.parseExpr(string);
                if (bl) {
                    System.out.print(expr.toString() + " => ");
                }
                try {
                    NodeValue nodeValue = expr.eval(null, null);
                    System.out.println(nodeValue.asQuotedString());
                }
                catch (ExprEvalException exprEvalException) {
                    System.out.println("Exception: " + exprEvalException.getMessage());
                }
                continue;
            }
            catch (QueryParseException queryParseException) {
                System.err.println("Parse error: " + queryParseException.getMessage());
            }
        }
    }

    static void usage() {
        qexpr.usage(System.out);
    }

    static void usage(PrintStream printStream) {
        printStream.println("Usage: expression");
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
    }
}

