/*
 * Decompiled with CFR 0.152.
 */
package arq.cmd;

import arq.cmd.QExec;
import arq.cmd.ResultsFormat;
import com.hp.hpl.jena.query.DataFormat;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.engineHTTP.HttpQuery;
import com.hp.hpl.jena.query.engineHTTP.QueryExceptionHTTP;
import com.hp.hpl.jena.query.lang.Parser;
import com.hp.hpl.jena.query.resultset.ResultSetException;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QCmd
implements Serializable {
    static final long serialVersionUID = 7761L;
    private static Log log = LogFactory.getLog((Class)QCmd.class);
    private String queryString = null;
    private String queryFilename = null;
    private String syntaxHint = null;
    private Syntax inSyntax = null;
    private Syntax defaultSyntax = null;
    private Query query = null;
    private String baseURI = null;
    private Dataset dataset = null;
    private String service = null;
    private boolean forcePost = false;
    private FileManager fileManager = null;
    private List graphURLs = null;
    private List namedGraphURLs = null;
    private DataFormat dataSyntax = null;
    private Syntax outSyntax = null;
    private boolean lineNumbers = false;
    private ResultsFormat outputFormat = null;
    private int messageLevel = 0;

    public void query() {
        this.queryFixOutputFormat();
        if (this.service != null) {
            this.queryRemote();
        } else {
            this.queryLocal();
        }
    }

    public void printQuery() {
        IndentedWriter indentedWriter = new IndentedWriter(System.out, this.lineNumbers);
        this.query.serialize(indentedWriter, this.outSyntax);
        indentedWriter.flush();
    }

    public void checkParse() {
        if (!Parser.canParse(this.outSyntax)) {
            return;
        }
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        this.query.serialize(indentedLineBuffer, this.outSyntax);
        String string = indentedLineBuffer.toString();
        Query query2 = null;
        try {
            String string2 = null;
            if (!this.query.explicitlySetBaseURI()) {
                string2 = this.query.getBaseURI();
            }
            if ((query2 = QueryFactory.create(string, string2, this.outSyntax)) == null) {
                return;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        catch (QueryException queryException) {
            System.out.println();
            System.out.println("**** Check failed : could not parse output query:: ");
            System.out.println("**** " + queryException.getMessage());
            return;
        }
        if (this.query.hashCode() != query2.hashCode()) {
            System.out.println();
            System.out.println("**** Check failed : reparsed query hashCode does not equal parsed input query");
        }
        if (!this.query.equals(query2)) {
            System.out.println();
            System.out.println("**** Check failed : reparsed output does not equal parsed input");
            return;
        }
    }

    void queryLocal() {
        this.queryFixDataset();
        this.dumpData();
        this.parseQuery();
        if (this.query == null) {
            return;
        }
        this.queryExecLocal();
    }

    void queryFixDataset() {
        try {
            if (this.graphURLs != null || this.namedGraphURLs != null) {
                this.dataset = DatasetFactory.create(this.graphURLs, this.namedGraphURLs, this.fileManager, null);
            }
        }
        catch (JenaException jenaException) {
            System.err.println("Error loading URL: " + jenaException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println("Error creating dataset: " + exception);
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    void queryFixOutputFormat() {
        if (this.outputFormat == null) {
            this.outputFormat = ResultsFormat.FMT_TEXT;
        }
    }

    public void parseQuery() {
        if (this.query != null) {
            return;
        }
        if (this.queryFilename != null && this.queryString != null) {
            System.err.println("Both query string and query file name given");
            return;
        }
        if (this.queryFilename == null && this.queryString == null) {
            System.err.println("No query string and no query file name given");
            return;
        }
        try {
            if (this.queryFilename != null) {
                if (this.queryFilename.equals("-")) {
                    try {
                        this.queryString = FileUtils.readWholeFileAsUTF8((InputStream)System.in);
                    }
                    catch (IOException iOException) {
                        System.err.println("reading stdin");
                        System.exit(9);
                    }
                } else {
                    this.query = QueryFactory.read(this.queryFilename, this.baseURI, this.inSyntax);
                }
            }
            if (this.queryString != null) {
                if (this.inSyntax == null) {
                    this.inSyntax = Syntax.syntaxSPARQL;
                }
                this.query = QueryFactory.create(this.queryString, this.baseURI, this.inSyntax);
            }
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
            return;
        }
        catch (QueryParseException queryParseException) {
            System.err.println(queryParseException.getMessage());
            return;
        }
        catch (QueryException queryException) {
            System.err.println(queryException.getMessage());
            return;
        }
        catch (JenaException jenaException) {
            System.err.println(jenaException.getMessage());
            return;
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
            return;
        }
    }

    void queryExecLocal() {
        try {
            QueryExecution queryExecution = QueryExecutionFactory.create(this.query, this.dataset);
            if (this.dataset == null && !this.query.hasDatasetDescription()) {
                System.err.println("Dataset not specified in query nor provided on command line.");
                return;
            }
            if (this.fileManager != null) {
                queryExecution.setFileManager(this.fileManager);
            }
            QExec.doQuery(this.query, queryExecution, this.outputFormat);
            queryExecution.close();
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
        }
        catch (ResultSetException resultSetException) {
            System.err.println(resultSetException.getMessage());
            resultSetException.printStackTrace(System.err);
        }
        catch (QueryException queryException) {
            System.err.println("Query Exeception: " + (Object)((Object)queryException));
            System.exit(9);
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
        }
    }

    private void queryRemote() {
        this.parseQuery();
        if (this.query == null) {
            return;
        }
        try {
            QueryExecution queryExecution = QueryExecutionFactory.sparqlService(this.service, this.query, this.getGraphURLs(), this.getNamedGraphURLs());
            if (this.messageLevel > 0) {
                System.out.println(queryExecution.toString());
            }
            if (this.getForcePost()) {
                HttpQuery.urlLimit = 0;
            }
            QExec.doQuery(this.query, queryExecution, this.outputFormat);
        }
        catch (QueryExceptionHTTP queryExceptionHTTP) {
            System.err.println("HTTP Exeception: " + queryExceptionHTTP.getMessage());
            System.exit(9);
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
        }
    }

    void dumpData() {
        boolean bl = false;
        if (bl) {
            if (this.dataset == null) {
                System.out.println("Dataset is null");
            } else {
                System.out.println("Dataset: " + this.dataset);
            }
        }
    }

    public String getServiceURL() {
        return this.service;
    }

    public void setServiceURL(String string) {
        this.service = string;
    }

    public boolean getForcePost() {
        return this.forcePost;
    }

    public void setForcePost(boolean bl) {
        this.forcePost = bl;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public DataFormat getDataSyntax() {
        return this.dataSyntax;
    }

    public void setDataSyntax(DataFormat dataFormat) {
        this.dataSyntax = dataFormat;
    }

    public Syntax getDefaultSyntax() {
        return this.defaultSyntax;
    }

    public void setDefaultSyntax(Syntax syntax) {
        this.defaultSyntax = syntax;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public List getGraphURLs() {
        return this.graphURLs;
    }

    public void setGraphURLs(List list2) {
        this.graphURLs = list2;
    }

    public Syntax getInSyntax() {
        return this.inSyntax;
    }

    public void setInSyntax(Syntax syntax) {
        this.inSyntax = syntax;
    }

    public boolean isLineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(boolean bl) {
        this.lineNumbers = bl;
    }

    public int getMessageLevel() {
        return this.messageLevel;
    }

    public void setMessageLevel(int n) {
        this.messageLevel = n;
    }

    public List getNamedGraphURLs() {
        return this.namedGraphURLs;
    }

    public void setNamedGraphURLs(List list2) {
        this.namedGraphURLs = list2;
    }

    public ResultsFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(ResultsFormat resultsFormat) {
        this.outputFormat = resultsFormat;
    }

    public Syntax getOutSyntax() {
        return this.outSyntax;
    }

    public void setOutSyntax(Syntax syntax) {
        this.outSyntax = syntax;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query2) {
        this.query = query2;
    }

    public String getQueryFilename() {
        return this.queryFilename;
    }

    public void setQueryFilename(String string) {
        this.queryFilename = string;
        this.setSyntaxHint(string);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public String getSyntaxHint() {
        return this.syntaxHint;
    }

    public void setSyntaxHint(String string) {
        this.syntaxHint = string;
        if (this.inSyntax == null) {
            this.inSyntax = Syntax.guessQueryFileSyntax(string);
        }
        if (this.outSyntax == null) {
            this.outSyntax = Syntax.guessQueryFileSyntax(string);
        }
    }
}

