/*
 * Decompiled with CFR 0.152.
 */
package jena.test;

import junit.framework.TestCase;

public class rdfcat
extends TestCase {
    public void testAbbreviationTable() {
        rdfcat.assertEquals((Object)"RDF/XML", jena.rdfcat.unabbreviate.get("x"));
        rdfcat.assertEquals((Object)"RDF/XML", jena.rdfcat.unabbreviate.get("rdf"));
        rdfcat.assertEquals((Object)"RDF/XML", jena.rdfcat.unabbreviate.get("rdfxml"));
        rdfcat.assertEquals((Object)"RDF/XML", jena.rdfcat.unabbreviate.get("xml"));
        rdfcat.assertEquals((Object)"N3", jena.rdfcat.unabbreviate.get("n3"));
        rdfcat.assertEquals((Object)"N3", jena.rdfcat.unabbreviate.get("n"));
        rdfcat.assertEquals((Object)"N3", jena.rdfcat.unabbreviate.get("ttl"));
        rdfcat.assertEquals((Object)"N-TRIPLE", jena.rdfcat.unabbreviate.get("ntriples"));
        rdfcat.assertEquals((Object)"N-TRIPLE", jena.rdfcat.unabbreviate.get("ntriple"));
        rdfcat.assertEquals((Object)"N-TRIPLE", jena.rdfcat.unabbreviate.get("t"));
        rdfcat.assertEquals((Object)"RDF/XML-ABBREV", jena.rdfcat.unabbreviate.get("owl"));
        rdfcat.assertEquals((Object)"RDF/XML-ABBREV", jena.rdfcat.unabbreviate.get("abbrev"));
    }

    public void testExistingLanguage() {
        rdfcat.assertEquals((String)"RDF/XML", (String)jena.rdfcat.getCheckedLanguage((String)"x"));
        rdfcat.assertEquals((String)"RDF/XML", (String)jena.rdfcat.getCheckedLanguage((String)"xml"));
        rdfcat.assertEquals((String)"RDF/XML-ABBREV", (String)jena.rdfcat.getCheckedLanguage((String)"owl"));
        rdfcat.assertEquals((String)"N3", (String)jena.rdfcat.getCheckedLanguage((String)"N3"));
        rdfcat.assertEquals((String)"N-TRIPLE", (String)jena.rdfcat.getCheckedLanguage((String)"N-TRIPLE"));
    }

    public void testNonexistantLanguage() {
        try {
            jena.rdfcat.getCheckedLanguage((String)"noSuchLanguageAsThisOneFruitcake");
            rdfcat.fail((String)"should trap non-existant language");
        }
        catch (IllegalArgumentException e) {
            rdfcat.assertTrue((String)"message should mention bad language", (e.getMessage().indexOf("Fruitcake") > 0 ? 1 : 0) != 0);
        }
    }
}

