/*
 * Decompiled with CFR 0.152.
 */
package jena.test;

import jena.rdfcat;
import junit.framework.TestCase;

public class Test_rdfcat
extends TestCase {
    public void testAbbreviationTable() {
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("x"));
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("rdf"));
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("rdfxml"));
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("xml"));
        Test_rdfcat.assertEquals((Object)"N3", rdfcat.unabbreviate.get("n3"));
        Test_rdfcat.assertEquals((Object)"N3", rdfcat.unabbreviate.get("n"));
        Test_rdfcat.assertEquals((Object)"N3", rdfcat.unabbreviate.get("ttl"));
        Test_rdfcat.assertEquals((Object)"N-TRIPLE", rdfcat.unabbreviate.get("ntriples"));
        Test_rdfcat.assertEquals((Object)"N-TRIPLE", rdfcat.unabbreviate.get("ntriple"));
        Test_rdfcat.assertEquals((Object)"N-TRIPLE", rdfcat.unabbreviate.get("t"));
        Test_rdfcat.assertEquals((Object)"RDF/XML-ABBREV", rdfcat.unabbreviate.get("owl"));
        Test_rdfcat.assertEquals((Object)"RDF/XML-ABBREV", rdfcat.unabbreviate.get("abbrev"));
    }

    public void testExistingLanguage() {
        Test_rdfcat.assertEquals((String)"RDF/XML", (String)rdfcat.getCheckedLanguage((String)"x"));
        Test_rdfcat.assertEquals((String)"RDF/XML", (String)rdfcat.getCheckedLanguage((String)"xml"));
        Test_rdfcat.assertEquals((String)"RDF/XML-ABBREV", (String)rdfcat.getCheckedLanguage((String)"owl"));
        Test_rdfcat.assertEquals((String)"N3", (String)rdfcat.getCheckedLanguage((String)"N3"));
        Test_rdfcat.assertEquals((String)"N-TRIPLE", (String)rdfcat.getCheckedLanguage((String)"N-TRIPLE"));
    }

    public void testNonexistantLanguage() {
        try {
            rdfcat.getCheckedLanguage((String)"noSuchLanguageAsThisOneFruitcake");
            Test_rdfcat.fail((String)"should trap non-existant language");
        }
        catch (IllegalArgumentException e) {
            Test_rdfcat.assertTrue((String)"message should mention bad language", (e.getMessage().indexOf("Fruitcake") > 0 ? 1 : 0) != 0);
        }
    }
}

