/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.xmloutput.test.PrettyWriterTest;
import com.hp.hpl.jena.xmloutput.test.TestMacEncodings;
import com.hp.hpl.jena.xmloutput.test.testWriterAndReader;
import com.hp.hpl.jena.xmloutput.test.testWriterInterface;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPackage
extends TestCase {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        String[] langs = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE"};
        suite.addTest((Test)TestMacEncodings.suite());
        suite.addTest((Test)new PrettyWriterTest("testAnonDamlClass"));
        suite.addTest((Test)new PrettyWriterTest("testLi"));
        suite.addTest((Test)new PrettyWriterTest("test803804"));
        suite.addTest((Test)new PrettyWriterTest("testRDFCollection"));
        suite.addTest((Test)new PrettyWriterTest("testOWLPrefix"));
        suite.addTest((Test)new testWriterInterface("testInterface", null));
        suite.addTest((Test)new testWriterInterface("testNoWriter", null));
        suite.addTest((Test)new testWriterInterface("testAnotherWriter", null));
        for (int i = 0; i < langs.length; ++i) {
            suite.addTest(testWriterAndReader.suite(langs[i]));
        }
        suite.addTest((Test)new TestSuite(TestURIExceptions.class));
        return suite;
    }

    public static class TestURIExceptions
    extends TestCase {
        public TestURIExceptions(String name) {
            super(name);
        }

        public void testBadURIExceptionContainsBadURIInMessage() {
            String badURI = "http:";
            Model m = ModelFactory.createDefaultModel();
            m.add(m.createResource(badURI), m.createProperty("eg:B C"), (RDFNode)m.createResource("eg:C D"));
            try {
                m.write((Writer)new StringWriter());
                TestURIExceptions.fail((String)("should detect bad URI " + badURI));
            }
            catch (BadURIException e) {
                TestURIExceptions.assertTrue((String)"message must contain failing URI", (e.getMessage().indexOf(badURI) > 0 ? 1 : 0) != 0);
            }
        }
    }
}

