/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestDigReasoner
extends TestCase {
    private static Log log = LogFactory.getLog((Class)TestDigReasoner.class);
    protected Model m_base;

    public TestDigReasoner(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite s = new TestSuite("TestDigReasoner");
        TestDigReasoner.buildConceptLangSuite("testing/ontology/dig/owl/cl", OntModelSpec.OWL_MEM, s);
        TestDigReasoner.buildBasicQuerySuite("testing/ontology/dig/owl/basicq", OntModelSpec.OWL_MEM, s);
        s.addTestSuite(TestDigReasoner.class);
        return s;
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testAxioms() {
        DIGReasoner r = ReasonerRegistry.getDIGReasoner();
        DIGReasoner ro = ReasonerRegistry.getDIGReasoner((Resource)OWL.NAMESPACE, null);
        DIGReasoner rd = ReasonerRegistry.getDIGReasoner((Resource)DAML_OIL.NAMESPACE_DAML, null);
        DIGReasoner roA = ReasonerRegistry.getDIGReasoner((Resource)OWL.NAMESPACE, (boolean)true, null);
        DIGReasoner rdA = ReasonerRegistry.getDIGReasoner((Resource)DAML_OIL.NAMESPACE_DAML, (boolean)true, null);
        this.axiomTestAux(r, OntModelSpec.OWL_MEM, false, false);
        this.axiomTestAux(ro, OntModelSpec.OWL_MEM, false, false);
        this.axiomTestAux(rd, OntModelSpec.DAML_MEM, false, false);
        this.axiomTestAux(roA, OntModelSpec.OWL_MEM, true, false);
        this.axiomTestAux(rdA, OntModelSpec.DAML_MEM, false, true);
    }

    private void axiomTestAux(DIGReasoner dr, OntModelSpec baseSpec, boolean owlResult, boolean damlResult) {
        OntModelSpec spec = new OntModelSpec(baseSpec);
        spec.setReasoner((Reasoner)dr);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        TestDigReasoner.assertEquals((String)"Result for owl:ObjectProperty", (boolean)owlResult, (boolean)m.contains(OWL.ObjectProperty, RDF.type, (RDFNode)RDFS.Class));
        TestDigReasoner.assertEquals((String)"Result for daml:ObjectProperty", (boolean)damlResult, (boolean)m.contains(DAML_OIL.ObjectProperty, RDF.type, (RDFNode)RDFS.Class));
    }

    public void testQueryAllConcepts() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        TestUtil.assertIteratorValues(this, (Iterator)m.listClasses(), new Resource[]{m.getResource(NS + "A"), m.getResource(NS + "B"), m.getResource(NS + "C"), m.getResource(NS + "D"), m.getResource(NS + "E"), m.getResource(NS + "BB"), m.getResource(NS + "F0"), m.getResource(NS + "F1"), m.getResource(NS + "F2")}, 2);
    }

    public void testQuerySubsumes1() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass B = m.getOntClass(NS + "B");
        TestDigReasoner.assertTrue((String)"A should be a sub-class of B", (boolean)A.hasSuperClass((Resource)B));
    }

    public void testQuerySubsumes2() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass C = m.getOntClass(NS + "C");
        OntClass D = m.getOntClass(NS + "D");
        TestDigReasoner.assertTrue((String)"D should be a sub-class of C", (boolean)D.hasSuperClass((Resource)C));
    }

    public void testQuerySubsumes3() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass C = m.getOntClass(NS + "C");
        TestDigReasoner.assertFalse((String)"A should not be a super-class of C", (boolean)C.hasSuperClass((Resource)A));
        TestDigReasoner.assertFalse((String)"C should not be a super-class of A", (boolean)A.hasSuperClass((Resource)C));
    }

    public void testAncestors0() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass B = m.getOntClass(NS + "B");
        OntClass BB = m.getOntClass(NS + "BB");
        TestUtil.assertIteratorValues(this, (Iterator)A.listSuperClasses(), new Resource[]{B, BB, OWL.Thing});
    }

    public void testAncestors1() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass B = m.getOntClass(NS + "B");
        OntClass BB = m.getOntClass(NS + "BB");
        TestDigReasoner.assertTrue((boolean)A.hasSuperClass((Resource)B));
        TestDigReasoner.assertTrue((boolean)A.hasSuperClass((Resource)BB));
        TestDigReasoner.assertTrue((boolean)B.hasSuperClass((Resource)BB));
        TestDigReasoner.assertTrue((boolean)BB.hasSubClass((Resource)B));
        TestDigReasoner.assertTrue((boolean)BB.hasSubClass((Resource)A));
        TestDigReasoner.assertTrue((boolean)B.hasSubClass((Resource)A));
        TestDigReasoner.assertFalse((boolean)B.hasSuperClass((Resource)A));
        TestDigReasoner.assertFalse((boolean)A.hasSubClass((Resource)BB));
        TestDigReasoner.assertTrue((boolean)A.hasSuperClass(OWL.Thing));
        TestDigReasoner.assertFalse((boolean)A.hasSubClass(OWL.Thing));
    }

    public void testDescendants() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass B = m.getOntClass(NS + "B");
        OntClass BB = m.getOntClass(NS + "BB");
        TestUtil.assertIteratorValues(this, (Iterator)BB.listSubClasses(), new Resource[]{B, A, OWL.Nothing});
    }

    public void testAllClassHierarchy() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass B = m.getOntClass(NS + "B");
        OntClass BB = m.getOntClass(NS + "BB");
        OntClass C = m.getOntClass(NS + "C");
        OntClass D = m.getOntClass(NS + "D");
        OntClass E = m.getOntClass(NS + "E");
        OntClass F0 = m.getOntClass(NS + "F0");
        OntClass F1 = m.getOntClass(NS + "F1");
        OntClass F2 = m.getOntClass(NS + "F2");
        TestUtil.assertIteratorValues(this, (Iterator)m.listStatements(null, RDFS.subClassOf, (RDFNode)null), new Statement[]{m.createStatement((Resource)A, RDFS.subClassOf, (RDFNode)A), m.createStatement((Resource)A, RDFS.subClassOf, (RDFNode)B), m.createStatement((Resource)A, RDFS.subClassOf, (RDFNode)BB), m.createStatement((Resource)B, RDFS.subClassOf, (RDFNode)B), m.createStatement((Resource)B, RDFS.subClassOf, (RDFNode)BB), m.createStatement((Resource)BB, RDFS.subClassOf, (RDFNode)BB), m.createStatement((Resource)C, RDFS.subClassOf, (RDFNode)C), m.createStatement((Resource)D, RDFS.subClassOf, (RDFNode)D), m.createStatement((Resource)D, RDFS.subClassOf, (RDFNode)C), m.createStatement((Resource)E, RDFS.subClassOf, (RDFNode)C), m.createStatement((Resource)E, RDFS.subClassOf, (RDFNode)E), m.createStatement((Resource)F0, RDFS.subClassOf, (RDFNode)F0), m.createStatement((Resource)F1, RDFS.subClassOf, (RDFNode)F1), m.createStatement((Resource)F2, RDFS.subClassOf, (RDFNode)F2), m.createStatement((Resource)A, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)B, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)BB, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)C, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)D, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)E, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)F0, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)F1, RDFS.subClassOf, (RDFNode)OWL.Thing), m.createStatement((Resource)F2, RDFS.subClassOf, (RDFNode)OWL.Thing)}, 4);
    }

    public void testQueryDisjoint1() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass C = m.getOntClass(NS + "C");
        TestDigReasoner.assertTrue((String)"A should be disjoint with C", (boolean)A.isDisjointWith((Resource)C));
        TestDigReasoner.assertTrue((String)"C should be disjoint with A", (boolean)C.isDisjointWith((Resource)A));
    }

    public void testQueryDisjoint2() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass F0 = m.getOntClass(NS + "F0");
        OntClass F1 = m.getOntClass(NS + "F1");
        TestDigReasoner.assertTrue((String)"F0 should be disjoint with F1", (boolean)F0.isDisjointWith((Resource)F1));
        TestDigReasoner.assertTrue((String)"F1 should be disjoint with F0", (boolean)F1.isDisjointWith((Resource)F0));
    }

    public void testParents0() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass B = m.getOntClass(NS + "B");
        TestUtil.assertIteratorValues(this, (Iterator)A.listSuperClasses(true), new Resource[]{B});
    }

    public void testParents1() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass A = m.getOntClass(NS + "A");
        OntClass B = m.getOntClass(NS + "B");
        OntClass BB = m.getOntClass(NS + "BB");
        TestDigReasoner.assertTrue((boolean)A.hasSuperClass((Resource)B, true));
        TestDigReasoner.assertTrue((boolean)B.hasSubClass((Resource)A, true));
        TestDigReasoner.assertFalse((boolean)A.hasSuperClass((Resource)BB, true));
        TestDigReasoner.assertTrue((boolean)BB.hasSuperClass(OWL.Thing, true));
        TestDigReasoner.assertFalse((boolean)B.hasSuperClass(OWL.Thing, true));
    }

    public void testChildren() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass B = m.getOntClass(NS + "B");
        OntClass BB = m.getOntClass(NS + "BB");
        TestUtil.assertIteratorValues(this, (Iterator)BB.listSubClasses(true), new Resource[]{B});
    }

    public void testEquivalents() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass F0 = m.getOntClass(NS + "F0");
        OntClass F2 = m.getOntClass(NS + "F2");
        OntClass F1 = m.getOntClass(NS + "F1");
        TestUtil.assertIteratorValues(this, (Iterator)F0.listEquivalentClasses(), new Resource[]{F2, F0}, 1);
        TestUtil.assertIteratorValues(this, (Iterator)F2.listEquivalentClasses(), new Resource[]{F0, F2}, 1);
        TestUtil.assertIteratorValues(this, (Iterator)F1.listEquivalentClasses(), new Resource[]{F1}, 1);
    }

    public void testIsEquivalent() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass F0 = m.getOntClass(NS + "F0");
        OntClass F2 = m.getOntClass(NS + "F2");
        OntClass F1 = m.getOntClass(NS + "F1");
        TestDigReasoner.assertTrue((String)"F0 should be equivalent to F2", (boolean)F0.hasEquivalentClass((Resource)F2));
        TestDigReasoner.assertFalse((String)"F0 should not be equivalent to F1", (boolean)F1.hasEquivalentClass((Resource)F0));
    }

    public void testRAncestors() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty p0 = m.getObjectProperty(NS + "p0");
        ObjectProperty p1 = m.getObjectProperty(NS + "p1");
        ObjectProperty p2 = m.getObjectProperty(NS + "p2");
        TestUtil.assertIteratorValues(this, (Iterator)p0.listSuperProperties(), new Resource[]{p1, p2, p0});
    }

    public void testRDescendants() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty p0 = m.getObjectProperty(NS + "p0");
        ObjectProperty p1 = m.getObjectProperty(NS + "p1");
        ObjectProperty p2 = m.getObjectProperty(NS + "p2");
        TestUtil.assertIteratorValues(this, (Iterator)p2.listSubProperties(), new Resource[]{p1, p0, p2});
    }

    public void testRParents() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty p0 = m.getObjectProperty(NS + "p0");
        ObjectProperty p1 = m.getObjectProperty(NS + "p1");
        TestUtil.assertIteratorValues(this, (Iterator)p0.listSuperProperties(true), new Resource[]{p1});
    }

    public void testRChildren() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty p1 = m.getObjectProperty(NS + "p1");
        ObjectProperty p2 = m.getObjectProperty(NS + "p2");
        TestUtil.assertIteratorValues(this, (Iterator)p2.listSubProperties(true), new Resource[]{p1});
    }

    public void testInstances() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass F0 = m.getOntClass(NS + "F0");
        Resource i0 = m.getResource(NS + "i0");
        Resource i1 = m.getResource(NS + "i1");
        Resource i2 = m.getResource(NS + "i2");
        Resource q0 = m.getResource(NS + "q0");
        Resource q1 = m.getResource(NS + "q1");
        Resource q2 = m.getResource(NS + "q2");
        TestUtil.assertIteratorValues(this, (Iterator)F0.listInstances(), new Resource[]{i0, i1, i2, q0, q2, q1});
    }

    public void testTypes() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass F0 = m.getOntClass(NS + "F0");
        OntClass F2 = m.getOntClass(NS + "F2");
        Individual i0 = m.getIndividual(NS + "i0");
        TestUtil.assertIteratorValues(this, (Iterator)i0.listRDFTypes(false), new Resource[]{F0, F2, OWL.Thing}, 1);
    }

    public void testInstance() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass F0 = m.getOntClass(NS + "F0");
        OntClass F1 = m.getOntClass(NS + "F1");
        Individual i0 = m.getIndividual(NS + "i0");
        TestDigReasoner.assertTrue((String)"i0 should be an instance of F0", (boolean)i0.hasRDFType((Resource)F0));
        TestDigReasoner.assertFalse((String)"i0 should not be an instance of F1", (boolean)i0.hasRDFType((Resource)F1));
    }

    public void testRoleFillers() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        Individual q0 = m.getIndividual(NS + "q0");
        Individual q1 = m.getIndividual(NS + "q1");
        Individual q2 = m.getIndividual(NS + "q2");
        Property q = m.getProperty(NS + "q");
        TestUtil.assertIteratorValues(this, (Iterator)q0.listPropertyValues(q), new Resource[]{q1, q2}, 0);
    }

    public void testIncrementalAdd() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass F0 = m.createClass(NS + "F0");
        OntClass F1 = m.createClass(NS + "F1");
        OntClass F2 = m.createClass(NS + "F2");
        Individual i0 = m.createIndividual(NS + "i0", (Resource)F0);
        TestDigReasoner.assertFalse((String)"i0 is not an F2", (boolean)i0.hasRDFType((Resource)F2));
        F0.addSuperClass((Resource)F1);
        F1.addSuperClass((Resource)F2);
        TestDigReasoner.assertTrue((String)"i0 should now be an F2", (boolean)i0.hasRDFType((Resource)F2));
    }

    public void testIncrementalRemove() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass F0 = m.createClass(NS + "F0");
        OntClass F1 = m.createClass(NS + "F1");
        OntClass F2 = m.createClass(NS + "F2");
        Individual i0 = m.createIndividual(NS + "i0", (Resource)F0);
        F0.addSuperClass((Resource)F1);
        F1.addSuperClass((Resource)F2);
        TestDigReasoner.assertTrue((String)"i0 is an F2", (boolean)i0.hasRDFType((Resource)F2));
        F0.removeSuperClass((Resource)F1);
        TestDigReasoner.assertFalse((String)"i0 should now not be an F2", (boolean)i0.hasRDFType((Resource)F2));
    }

    public void testRemoveIndividual() {
        Resource r0;
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass F0 = m.createClass(NS + "F0");
        Individual i0 = m.getIndividual(NS + "i0");
        boolean sawI0 = false;
        ExtendedIterator i = F0.listInstances();
        while (i.hasNext()) {
            r0 = (Resource)i.next();
            log.debug((Object)("Pre remove, saw F0 instance " + r0));
            sawI0 = sawI0 || r0.getURI().equals(i0.getURI());
        }
        TestDigReasoner.assertTrue((boolean)sawI0);
        i0.remove();
        sawI0 = false;
        i = F0.listInstances();
        while (i.hasNext()) {
            r0 = (Resource)i.next();
            log.debug((Object)("Post remove, saw F0 instance " + r0));
            sawI0 = sawI0 || r0.getURI().equals(i0.getURI());
        }
        TestDigReasoner.assertFalse((boolean)sawI0);
    }

    public void testRelatedIndividuals() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass F0 = m.createClass(NS + "F0");
        Individual i0 = F0.createIndividual(NS + "i0");
        Individual i1 = F0.createIndividual(NS + "i1");
        Individual i2 = F0.createIndividual(NS + "i2");
        TransitiveProperty p = m.createTransitiveProperty(NS + "p");
        i0.addProperty((Property)p, (RDFNode)i1);
        i1.addProperty((Property)p, (RDFNode)i2);
        int count = 0;
        StmtIterator i = m.listStatements(null, (Property)p, (RDFNode)null);
        while (i.hasNext()) {
            Statement s = i.nextStatement();
            ++count;
        }
        TestDigReasoner.assertEquals((String)"Should find 3 statements", (int)3, (int)count);
    }

    public void test_bug_codebaker_01() {
        String NS = "http://www.owl-ontologies.com/pizza.owl#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.read("file:testing/ontology/bugs/test_codebaker_01.owl");
        OntClass mp = m.getOntClass(NS + "MargheritaPizza");
        OntClass cp = m.getOntClass(NS + "CheesyPizza");
        TestDigReasoner.assertTrue((String)"MargheritaPizza should be cheesy", (boolean)mp.hasSuperClass((Resource)cp));
    }

    public void test_bug_koala_01() {
        Model cModel = ModelFactory.createDefaultModel();
        Resource conf = cModel.createResource();
        conf.addProperty(ReasonerVocabulary.EXT_REASONER_URL, (RDFNode)cModel.createResource("http://localhost:8081"));
        DIGReasonerFactory drf = (DIGReasonerFactory)ReasonerRegistry.theRegistry().getFactory("http://jena.hpl.hp.com/2003/DIGReasoner");
        DIGReasoner r = (DIGReasoner)drf.create(conf);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        m.getDocumentManager().addAltEntry("http://protege.stanford.edu/plugins/owl/owl-library/koala.owl", "file:testing/ontology/bugs/koala.owl");
        m.read("http://protege.stanford.edu/plugins/owl/owl-library/koala.owl");
        StmtIterator i = m.listStatements(null, OWL.equivalentClass, (RDFNode)OWL.Nothing);
        int unsatCount = 0;
        while (i.hasNext()) {
            i.nextStatement().getSubject();
            ++unsatCount;
        }
        TestDigReasoner.assertEquals((String)"Should be 4 unsatisfiable classes", (int)5, (int)unsatCount);
    }

    public void test_bug_mo_1() {
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass a = m.createClass(NS + "A");
        Individual i0 = m.createIndividual(NS + "i0", (Resource)a);
        int iCount = 0;
        int nonICount = 0;
        StmtIterator j = m.listStatements(null, RDF.type, (RDFNode)m.getResource(NS + "A"));
        while (j.hasNext()) {
            if (j.nextStatement().getSubject().equals(i0)) {
                ++iCount;
                continue;
            }
            ++nonICount;
        }
        TestDigReasoner.assertEquals((String)"Should be no non i0's", (int)0, (int)nonICount);
        TestDigReasoner.assertEquals((String)"Should be only one i0", (int)1, (int)iCount);
    }

    public void test_bug_mo_2() {
        boolean ex0 = false;
        boolean ex1 = false;
        String NS = "http://example.org/foo#";
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass a = model.createClass(NS + "A");
        Individual b = model.createIndividual(NS + "b", (Resource)a);
        Model base = model.getBaseModel();
        Literal lbl = base.createLiteral("fubar", "en");
        base.add((Resource)b, RDFS.label, (RDFNode)lbl);
        ExtendedIterator instances = model.listIndividuals();
        while (instances.hasNext()) {
            Individual inst = (Individual)instances.next();
            try {
                inst.getLabel("en");
            }
            catch (Exception e) {
                ex0 = true;
            }
            try {
                Resource baseInst = (Resource)inst.inModel(base);
                baseInst.getProperty(RDFS.label).getString();
            }
            catch (Exception e) {
                System.out.println("Second attempt failed " + e.getMessage());
                ex1 = true;
            }
        }
        TestDigReasoner.assertTrue((!ex0 && !ex1 ? 1 : 0) != 0);
    }

    public void test_bug_mo_3() {
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)r);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec);
        OntClass c0 = model.createClass("ns:A");
        c0.addLabel("this is just a test", "en");
        Model base = model.getBaseModel();
        OntClass cls = model.getOntClass("ns:A");
        System.out.println(cls.getLocalName());
        ExtendedIterator instances = cls.listInstances();
        while (instances.hasNext()) {
            Resource inst = (Resource)instances.next();
            Property p = base.getProperty("http://www.w3.org/2000/01/rdf-schema#", "label");
            Statement s = inst.getProperty(p);
            System.out.println(" " + s.getString());
        }
    }

    public void xxtestBasicQueryN() throws Exception {
        String root = "testing/ontology/dig/owl/basicq";
        int testN = 24;
        File testSource = new File(root + "/test_" + testN + ".source.xml");
        File testQuery = new File(root + "/test_" + testN + ".query.xml");
        File testTarget = new File(root + "/test_" + testN + ".result.xml");
        new DigBasicQueryTest(testSource, testTarget, testQuery, OntModelSpec.OWL_MEM).runTest();
    }

    private static void buildConceptLangSuite(String root, OntModelSpec spec, TestSuite s) {
        int i = 0;
        while (true) {
            File testSource = new File(root + "/test_" + i + ".source.xml");
            File testTarget = new File(root + "/test_" + i + ".xml");
            if (!testSource.exists()) break;
            ++i;
            s.addTest((Test)new DigTranslationTest(testSource, testTarget, spec));
        }
    }

    private static void buildBasicQuerySuite(String root, OntModelSpec spec, TestSuite s) {
        int i = 0;
        while (true) {
            File testSource = new File(root + "/test_" + i + ".source.xml");
            File testQuery = new File(root + "/test_" + i + ".query.xml");
            File testTarget = new File(root + "/test_" + i + ".result.xml");
            if (!testSource.exists()) break;
            ++i;
            s.addTest((Test)new DigBasicQueryTest(testSource, testTarget, testQuery, spec));
        }
    }

    private static class DigBasicQueryTest
    extends AbstractDigTest {
        private File m_source;
        private File m_target;
        private File m_query;
        private OntModelSpec m_spec;

        DigBasicQueryTest(File source, File target, File query, OntModelSpec spec) {
            super("BasicQueryTest " + source.getName());
            this.m_source = source;
            this.m_target = target;
            this.m_query = query;
            this.m_spec = spec;
        }

        public void runTest() throws Exception {
            boolean warn;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Model m = ModelFactory.createDefaultModel();
            m.read((InputStream)new FileInputStream(this.m_source), null);
            DIGAdapter da = new DIGAdapter(this.m_spec, m.getGraph());
            da.resetKB();
            boolean bl = warn = !da.uploadKB();
            if (warn) {
                System.err.println("00 Warning!");
                Iterator i = da.getConnection().getWarnings();
                while (i.hasNext()) {
                    System.err.println(i.next());
                }
                DigBasicQueryTest.assertFalse((String)"Should not be upload warnings", (boolean)warn);
            }
            Document queryD = builder.parse(this.m_query);
            Document targetD = builder.parse(this.m_target);
            log.debug((Object)("DIG test " + this.m_source.getPath()));
            Document resultD = da.getConnection().sendDigVerb(queryD, da.getProfile());
            da.getConnection().errorCheck(resultD, da.getProfile());
            DigBasicQueryTest.assertFalse((String)"Should not be warnings", (boolean)da.getConnection().warningCheck(resultD));
            da.close();
            this.xmlEqualityTest(resultD, targetD);
        }
    }

    private static class DigTranslationTest
    extends AbstractDigTest {
        private File m_source;
        private File m_target;
        private OntModelSpec m_spec;

        DigTranslationTest(File source, File target, OntModelSpec spec) {
            super("DigTranslationTest " + source.getName());
            this.m_source = source;
            this.m_target = target;
            this.m_spec = spec;
        }

        public void runTest() throws Exception {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Model m = ModelFactory.createDefaultModel();
            m.read((InputStream)new FileInputStream(this.m_source), null);
            DIGAdapter da = new DIGAdapter(this.m_spec, m.getGraph());
            Document targetD = builder.parse(this.m_target);
            Document sourceD = da.translateKbToDig();
            this.xmlEqualityTest(sourceD, targetD);
        }
    }

    private static class AbstractDigTest
    extends TestCase {
        private boolean debug = true;

        public AbstractDigTest(String name) {
            super(name);
        }

        protected void xmlEqualityTest(Document source, Document target) {
            PrintWriter out;
            boolean test = this.xmlEqualityTest(source.getDocumentElement(), target.getDocumentElement());
            if (this.debug && !test) {
                out = new PrintWriter(System.err);
                out.println(this.getName() + " expected:");
                new DIGConnection().serialiseDocument(target, (Writer)out);
                out.println();
                out.println("Saw:");
                new DIGConnection().serialiseDocument(source, (Writer)out);
                out.println();
            }
            AbstractDigTest.assertTrue((String)"Failed to match source to target documents", (boolean)test);
            test = this.xmlEqualityTest(target.getDocumentElement(), source.getDocumentElement());
            if (this.debug && !test) {
                out = new PrintWriter(System.err);
                out.println(this.getName() + " expected:");
                new DIGConnection().serialiseDocument(source, (Writer)out);
                out.println();
                out.println("Saw:");
                new DIGConnection().serialiseDocument(target, (Writer)out);
                out.println();
            }
            AbstractDigTest.assertTrue((String)"Failed to match target to source documents", (boolean)test);
        }

        private boolean xmlEqualityTest(Element source, Element target) {
            boolean match = source.getNodeName().equals(target.getNodeName());
            NodeList children = source.getChildNodes();
            for (int i = 0; match && i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                match = this.findElementMatch((Element)child, target);
            }
            NamedNodeMap attrs = source.getAttributes();
            for (int i = 0; match && i < attrs.getLength(); ++i) {
                match = this.findAttributeMatch((Attr)attrs.item(i), target);
            }
            return match;
        }

        private boolean findElementMatch(Element sourceChild, Element target) {
            boolean found = false;
            NodeList targetChildren = target.getElementsByTagName(sourceChild.getNodeName());
            for (int i = 0; !found && i < targetChildren.getLength(); ++i) {
                Node targetChild = targetChildren.item(i);
                if (!(targetChild instanceof Element) || !sourceChild.getNodeName().equals(targetChild.getNodeName())) continue;
                found = this.xmlEqualityTest(sourceChild, (Element)targetChild);
            }
            return found;
        }

        private boolean findAttributeMatch(Attr child, Element target) {
            String chValue = child.getValue();
            String targetValue = target.getAttribute(child.getName());
            return chValue.startsWith("anon:") && targetValue.startsWith("anon:") || chValue.equals(targetValue);
        }
    }
}

