/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.test.QueryTestException;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.TestManifest;
import com.hp.hpl.jena.vocabulary.TestQuery;

class TestItem {
    Resource testResource = null;
    Resource actionResource;
    String name;
    String resultFile;
    String comment;
    String dataFile;
    String queryFile;
    Resource queryForm;
    Resource resultForm;

    public String getName() {
        return this.name;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public Resource getQueryForm() {
        return this.queryForm;
    }

    public Resource getResultForm() {
        return this.resultForm;
    }

    TestItem(Resource r) {
        this.testResource = r;
        if (!r.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem with no action");
        }
        if (!r.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name");
        }
        this.name = this._getName();
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.dataFile = this._getDataFile();
        this.queryFile = this._getQueryFile();
        this.queryForm = this._getQueryForm();
        this.resultForm = this._getResultForm();
    }

    TestItem(String _name, String _queryFile, String _dataFile, String _resultFile) {
        this.name = _name;
        this.queryFile = _queryFile;
        this.dataFile = _dataFile;
        this.resultFile = _resultFile;
        this.comment = "";
        this.queryForm = null;
        this.resultForm = null;
    }

    public Resource getResource() {
        return this.testResource;
    }

    String _getName() {
        Statement s = this.testResource.getProperty(TestManifest.name);
        if (s == null) {
            return "<<unset>>";
        }
        return s.getString();
    }

    Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    String _getResultFile() {
        return this.getLiteralOrURI(this.testResource, TestManifest.result);
    }

    String _getComment() {
        Statement s = this.testResource.getProperty(RDFS.comment);
        if (s == null) {
            return null;
        }
        return s.getString();
    }

    String _getDataFile() {
        if (this._getAction().isAnon()) {
            return this.getLiteralOrURI(this._getAction(), TestQuery.data);
        }
        return null;
    }

    String _getQueryFile() {
        Resource r = this._getAction();
        if (r.hasProperty(TestQuery.query)) {
            return this.getLiteralOrURI(this._getAction(), TestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    Resource _getQueryForm() {
        return null;
    }

    Resource _getResultForm() {
        return null;
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        String name = this.getName();
        String comment = this.getComment();
        String actionStr = QueryPrintUtils.stringForRDFNode((RDFNode)this._getAction());
        sbuff.append("Name: " + name);
        if (this.getComment() != null) {
            sbuff.append("    Comment: " + this.getComment());
        }
        return sbuff.toString();
    }

    private String getLiteralOrURI(Resource r, Property p) {
        Resource r2;
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getString();
        }
        if (n instanceof Resource && !(r2 = (Resource)n).isAnon()) {
            return r2.getURI();
        }
        throw new QueryTestException("Manifest problem: " + QueryPrintUtils.stringForRDFNode((RDFNode)n) + " => " + QueryPrintUtils.stringForRDFNode((RDFNode)p));
    }
}

