/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdql.EvalFailureException;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.ExprNumeric;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestExpressions
extends TestSuite {
    static final String testSetName = "RDQL - Expressions";

    public static TestSuite suite() {
        return new TestExpressions(testSetName);
    }

    private TestExpressions(String name) {
        super(name);
        boolean FAILURE_OK = true;
        boolean NO_FAILURE = false;
        String xsd = "http://www.w3.org/2001/XMLSchema#";
        this.addTest((Test)new TestNumeric("7", 7L));
        this.addTest((Test)new TestNumeric("-3", -3L));
        this.addTest((Test)new TestNumeric("3+4+5", 12L));
        this.addTest((Test)new TestNumeric("(3+4)+5", 12L));
        this.addTest((Test)new TestNumeric("3+(4+5)", 12L));
        this.addTest((Test)new TestNumeric("3*4+5", 17L));
        this.addTest((Test)new TestNumeric("3*(4+5)", 27L));
        this.addTest((Test)new TestNumeric("10-3-5", 2L));
        this.addTest((Test)new TestNumeric("(10-3)-5", 2L));
        this.addTest((Test)new TestNumeric("10-(3-5)", 12L));
        this.addTest((Test)new TestNumeric("10-3+5", 12L));
        this.addTest((Test)new TestNumeric("10-(3+5)", 2L));
        this.addTest((Test)new TestNumeric("1<<2", 4L));
        this.addTest((Test)new TestNumeric("1<<2<<2", 16L));
        this.addTest((Test)new TestNumeric("10000>>2", 2500L));
        this.addTest((Test)new TestNumeric("1.5 + 2.5", 4.0));
        this.addTest((Test)new TestNumeric("1.5 + 2", 3.5));
        this.addTest((Test)new TestNumeric("4111222333444", 4111222333444L));
        this.addTest((Test)new TestNumeric("1234 + 4111222333444", 4111222334678L));
        this.addTest((Test)new TestBoolean("true", false, true));
        this.addTest((Test)new TestBoolean("false", false, false));
        this.addTest((Test)new TestBoolean("false || true", false, true));
        this.addTest((Test)new TestBoolean("false && true", false, false));
        this.addTest((Test)new TestBoolean("2 < 3", false, true));
        this.addTest((Test)new TestBoolean("2 > 3", false, false));
        this.addTest((Test)new TestBoolean("(2 < 3) && (3<4)", false, true));
        this.addTest((Test)new TestBoolean("(2 < 3) && (3>=4)", false, false));
        this.addTest((Test)new TestBoolean("(2 < 3) || (3>=4)", false, true));
        this.addTest((Test)new TestBoolean("2 == 3", false, false));
        this.addTest((Test)new TestBoolean("2 < '3'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" ne \"joe\"", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq \"joe\"", false, false));
        this.addTest((Test)new TestBoolean("\"fred\" eq \"fred\"", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq 'fred'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq 'fr\\ed'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" ne \"fred\"", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'^^<type1>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'joe'^^<type1>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'^^<type2>", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'fred'^^<type2>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<" + xsd + "string> eq 'fred'", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'fred'", false, true));
        this.addTest((Test)new TestBoolean("'21'^^<int> == '21'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\\1\" eq 'fred1'", false, true));
        this.addTest((Test)new TestBoolean("\"fred2\" eq 'fred\\2'", false, true));
        this.addTest((Test)new TestBoolean("'fred\\\\3' ne \"fred3\"", false, true));
        this.addTest((Test)new TestBoolean("\"urn:fred\" eq <urn:fred>", false, true));
        this.addTest((Test)new TestBoolean("\"urn:fred\" ne <urn:fred>", false, false));
        this.addTest((Test)new TestBoolean("\"urn:fred/1.5\" ne <urn:fred/1.5>", false, false));
        this.addTest((Test)new TestBoolean("\"xxx\"@fr langeq 'fr'", false, true));
        this.addTest((Test)new TestBoolean("\"xxx\"@fr langeq \"fr\"", false, true));
        this.addTest((Test)new TestBoolean("\"xxx\"@en-gb langeq 'en'", false, true));
        this.addTest((Test)new TestBoolean("\"xxx\"@en-gb langeq 'EN'", false, true));
        this.addTest((Test)new TestBoolean("\"xxx\"@en-gb langeq 'fr'", false, false));
        this.addTest((Test)new TestBoolean("\"chat\"@fr langeq 'en'", false, false));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /abbc/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /a..c/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /^aabb/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /cc$/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" !~ /abbc/", false, false));
        this.addTest((Test)new TestBoolean("\"aab*bcc\" =~ /ab\\*bc/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" ~~ /ab\\\\*bc/", false, true));
        this.addTest((Test)new TestBoolean("'aabbcc' =~ /B.*B/i", false, true));
        this.addTest((Test)new TestBoolean("1.5 < 2", false, true));
        this.addTest((Test)new TestBoolean("1.5 > 2", false, false));
        this.addTest((Test)new TestBoolean("1.5 < 2.3", false, true));
        this.addTest((Test)new TestBoolean("1.5 > 2.3", false, false));
        this.addTest((Test)new TestBoolean("4111222333444 > 1234", false, true));
        this.addTest((Test)new TestBoolean("4111222333444 < 1234", false, false));
        this.addTest((Test)new TestBoolean("2 < \"fred\"", true, false));
        this.addTest((Test)new TestBoolean("2 || true", true, false));
    }

    static class TestBoolean
    extends TestCase {
        String s;
        boolean failureCorrect;
        boolean rightAnswer;

        TestBoolean(String _s, boolean _failureCorrect, boolean _rightAnswer) {
            super("Boolean test : " + _s + " ");
            this.s = _s;
            this.failureCorrect = _failureCorrect;
            this.rightAnswer = _rightAnswer;
        }

        protected void runTest() throws Throwable {
            long initTime = 0L;
            long parseTime = 0L;
            long startTime = 0L;
            long stopTime = 0L;
            ByteArrayInputStream in = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser parser = new RDQLParser((InputStream)in);
            startTime = System.currentTimeMillis();
            try {
                parser.Expression();
            }
            catch (Error e) {
                TestCase.fail((String)("Error throw in parse: " + this.s));
            }
            stopTime = System.currentTimeMillis();
            parseTime = stopTime - startTime;
            parser.top().postParse(null);
            Expr e = (Expr)parser.top();
            TestBoolean.assertTrue((String)("Expression is not ExprBoolean: " + e.getClass().getName()), (boolean)(e instanceof ExprBoolean));
            ExprBoolean n = (ExprBoolean)e;
            NodeValue v = null;
            boolean result = false;
            try {
                v = n.eval(null, null);
                result = v.getBoolean();
            }
            catch (EvalFailureException evalEx) {
                if (!this.failureCorrect) {
                    throw evalEx;
                }
                result = false;
            }
            TestBoolean.assertEquals((String)(this.s + " => " + result + " [" + this.rightAnswer + "]"), (boolean)result, (boolean)this.rightAnswer);
        }
    }

    static class TestNumeric
    extends TestCase {
        String s;
        boolean isDouble = false;
        long rightAnswer;
        double rightAnswerDouble;

        TestNumeric(String _s, long _rightAnswer) {
            super("Numeric test : " + _s + " ");
            this.s = _s;
            this.rightAnswer = _rightAnswer;
            this.isDouble = false;
        }

        TestNumeric(String _s, double _rightAnswer) {
            super("Numeric test : " + _s + " ");
            this.s = _s;
            this.rightAnswerDouble = _rightAnswer;
            this.isDouble = true;
        }

        protected void runTest() throws Throwable {
            long initTime = 0L;
            long parseTime = 0L;
            long startTime = 0L;
            long stopTime = 0L;
            ByteArrayInputStream in = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser parser = new RDQLParser((InputStream)in);
            startTime = System.currentTimeMillis();
            try {
                parser.Expression();
            }
            catch (Error e) {
                TestNumeric.fail((String)("Error thrown in parse: " + e));
            }
            stopTime = System.currentTimeMillis();
            parseTime = stopTime - startTime;
            parser.top().postParse(null);
            Expr e = (Expr)parser.top();
            TestNumeric.assertTrue((String)("Expression is not ExprNumeric: " + e.getClass().getName()), (boolean)(e instanceof ExprNumeric));
            ExprNumeric n = (ExprNumeric)e;
            NodeValue v = n.eval(null, null);
            if (!this.isDouble) {
                TestNumeric.assertEquals((String)(this.s + " => " + v.getInt() + " [" + this.rightAnswer + "]"), (long)v.getInt(), (long)this.rightAnswer);
            } else {
                TestNumeric.assertEquals((String)(this.s + " => " + v.getDouble() + " [" + this.rightAnswerDouble + "]"), (double)v.getDouble(), (double)this.rightAnswerDouble, (double)1.0E-4);
            }
        }
    }
}

