/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.rdql.QueryResultsMem;
import com.hp.hpl.jena.rdql.test.TestItem;
import com.hp.hpl.jena.rdql.test.TestManifestList;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTestScripts
extends TestSuite {
    static final String testSetName = "RDQL - Query - Scripts";
    static final String directory = "testing/RDQL/";
    public static final String defaultControlFilename = "testing/RDQL/rdql-tests.n3";
    FileManager fm = null;
    public String basename = null;
    public static boolean printDetails = false;
    public static boolean displayTime = false;
    protected static Log log = LogFactory.getLog((Class)QueryTestScripts.class);
    static PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
    static int testCounter = 0;

    public static TestSuite suite() {
        return new QueryTestScripts(testSetName);
    }

    public QueryTestScripts(String name) {
        super(name);
        this.addTests(directory, defaultControlFilename);
    }

    public void addTest(TestItem item) {
        this.addTest("RDQL-test-" + ++testCounter, item);
    }

    public void addTest(String testName, TestItem item) {
        this.addTest(testName, null, item);
    }

    public void addTest(String testName, String directory, TestItem item) {
        this.addTest(null, testName, directory, item);
    }

    public void addTest(Model model, String testName, String directory, TestItem item) {
        RDQLTest test = new RDQLTest(model, testName, null, item);
        this.addTest((Test)test);
    }

    private void addTests(String dir, String testsFile) {
        LocatorFile locator = new LocatorFile(dir);
        PrintWriter out = new PrintWriter(System.out);
        Model tests = FileManager.get().loadModel(testsFile);
        TestManifestList manifest = new TestManifestList(tests);
        TestManifestList.TestIterator iter = manifest.iterator();
        while (iter.hasNext()) {
            TestItem item = iter.nextItem();
            RDQLTest test = new RDQLTest(null, item.getName(), (Locator)locator, item);
            this.addTest((Test)test);
        }
    }

    public static void emptyModel(Model model) {
        if (model == null) {
            return;
        }
        try {
            StmtIterator sIter = model.listStatements();
            while (sIter.hasNext()) {
                sIter.nextStatement();
                sIter.remove();
            }
            sIter.close();
        }
        catch (JenaException rdfEx) {
            log.error((Object)"Failed to empty model (com.hp.hpl.jena.rdf.query.Test.QueryTest.emptyModel)", (Throwable)rdfEx);
        }
    }

    static String convertFilename(String filename, String directory) {
        if (filename == null) {
            return null;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
        }
        if (directory != null && !filename.startsWith("/")) {
            filename = directory + "/" + filename;
        }
        return filename;
    }

    static String formatlong(long x) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(Long.toString(x));
        for (int i = sbuff.length(); i < 4; ++i) {
            sbuff.append(" ");
        }
        return sbuff.toString();
    }

    private static class RDQLTest
    extends TestCase {
        static int testCounter = 1;
        static boolean printModelsOnFailure = false;
        Model model;
        int testNumber = testCounter++;
        TestItem testItem;
        Locator locator;
        FileManager fileManager;

        RDQLTest(Model m, String testName, Locator locator, TestItem t) {
            super(testName);
            this.model = m;
            this.locator = locator;
            this.testItem = t;
        }

        protected void setUp() {
            this.fileManager = FileManager.get();
            if (this.locator != null) {
                FileManager.get().addLocator(this.locator);
            }
        }

        protected void tearDown() {
            if (this.locator != null) {
                FileManager.get().remove(this.locator);
            }
            this.fileManager = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws Throwable {
            Query query = null;
            try {
                if (printDetails) {
                    if (this.testNumber != 1) {
                        out.println();
                        out.println("------------------------------------------------------------------------");
                        out.println();
                    }
                    out.println("Test " + this.testNumber + " :: QueryFile=" + this.testItem.getQueryFile() + ", DataFile=" + this.testItem.getDataFile() + ", ResultsFile=" + this.testItem.getResultFile());
                }
                String queryString = this.fileManager.readWholeFileAsUTF8(this.testItem.getQueryFile());
                if (printDetails) {
                    out.println("Query:");
                    out.println(queryString);
                    if (!queryString.endsWith("\n")) {
                        out.println();
                    }
                    out.flush();
                }
                long startTime = System.currentTimeMillis();
                try {
                    query = new Query(queryString);
                }
                catch (QueryException qEx) {
                    query = null;
                    out.flush();
                    RDQLTest.assertFalse((String)("Parse failure: " + qEx.getMessage()), (boolean)true);
                    throw qEx;
                }
                if (printDetails) {
                    out.println("Parsed query:");
                    out.println(query.toString());
                    out.flush();
                }
                if (this.model == null) {
                    if (this.testItem.getDataFile() != null && !this.testItem.getDataFile().equals("")) {
                        long startLoadTime = System.currentTimeMillis();
                        Model m = this.fileManager.loadModel(this.testItem.getDataFile());
                        query.setSource(m);
                        query.loadTime = System.currentTimeMillis() - startLoadTime;
                    }
                } else {
                    QueryTestScripts.emptyModel(this.model);
                    String data = null;
                    if (this.testItem.getDataFile() != null && !this.testItem.getDataFile().equals("")) {
                        data = this.testItem.getDataFile();
                    }
                    if (data == null) {
                        data = query.getSourceURL();
                    }
                    try {
                        long startLoadTime = System.currentTimeMillis();
                        query.setSource(this.fileManager.readModel(this.model, data));
                        query.loadTime = System.currentTimeMillis() - startLoadTime;
                    }
                    catch (JenaException ex) {
                        log.warn((Object)("Problems loading data for: " + data));
                    }
                }
                QueryEngine qe = new QueryEngine(query);
                qe.init();
                this.runTestSelect(query, (QueryExecution)qe, startTime);
            }
            catch (IOException ioEx) {
                out.println("IOException: " + ioEx);
                ioEx.printStackTrace(out);
                out.flush();
            }
            catch (Exception ex) {
                out.println("Exception: " + ex);
                ex.printStackTrace(out);
                out.flush();
                Assert.assertTrue((String)("Exception: " + this.testItem.getQueryFile()), (boolean)false);
            }
            finally {
                if (this.model == null && query != null && query.getSource() != null) {
                    query.getSource().close();
                }
                out.flush();
            }
        }

        void runTestSelect(Query query, QueryExecution qe, long startTime) throws Exception {
            boolean testingResults;
            QueryResults resultsActual = qe.exec();
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            QueryResultsMem results = new QueryResultsMem(resultsActual);
            resultsActual.close();
            resultsActual = null;
            boolean bl = testingResults = this.testItem.getResultFile() != null && !this.testItem.getResultFile().equals("");
            if (printDetails) {
                QueryResultsFormatter fmt = new QueryResultsFormatter((QueryResults)results);
                fmt.printAll(out);
                out.println();
                fmt.close();
            }
            if (printDetails && displayTime) {
                out.println();
                out.println("Query parse:     " + QueryTestScripts.formatlong(query.parseTime) + " ms");
                out.println("Query build:     " + QueryTestScripts.formatlong(query.buildTime) + " ms");
                out.println("Data load time:  " + QueryTestScripts.formatlong(query.loadTime) + " ms");
                out.println("Query execute:   " + QueryTestScripts.formatlong(query.executeTime) + " ms");
                out.println("Query misc:      " + QueryTestScripts.formatlong(totalTime - query.parseTime - query.buildTime - query.loadTime - query.executeTime) + " ms");
                out.println("Query total:     " + QueryTestScripts.formatlong(totalTime) + " ms");
                out.flush();
            }
            if (testingResults) {
                try {
                    Model tmp = this.fileManager.loadModel(this.testItem.getResultFile());
                    QueryResultsMem qr1 = new QueryResultsMem((QueryResults)results);
                    QueryResultsMem qr2 = new QueryResultsMem(tmp);
                    if (!RDQLTest.resultSetEquivalent((QueryResults)qr1, (QueryResults)qr2)) {
                        out.println();
                        out.println("=======================================");
                        out.println("Failure: " + this.testItem.getQueryFile());
                        out.println("Got: " + qr1.size() + " ----------------------------------");
                        qr1.reset();
                        QueryResultsFormatter qrFmt1 = new QueryResultsFormatter((QueryResults)qr1);
                        qrFmt1.dump(out, false);
                        qr1.reset();
                        if (printModelsOnFailure) {
                            out.println("---------------------------------------");
                            qrFmt1.toModel().write((Writer)out, "N3");
                            qr1.reset();
                        }
                        out.flush();
                        QueryResultsFormatter qrFmt2 = new QueryResultsFormatter((QueryResults)qr2);
                        out.println("Expected: " + qr2.size() + " -----------------------------");
                        qr2.reset();
                        qrFmt2.dump(out, false);
                        qr2.reset();
                        if (printModelsOnFailure) {
                            out.println("---------------------------------------");
                            qrFmt2.toModel().write((Writer)out, "N3");
                            qr2.reset();
                        }
                        out.println();
                        out.flush();
                        qrFmt1.close();
                        qrFmt2.close();
                        qr1.close();
                        qr2.close();
                        Assert.assertTrue((String)("Results do not match: " + this.testItem.getQueryFile()), (boolean)false);
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)"Exception in result testing", (Throwable)ex);
                    Assert.fail((String)("Exception in result testing: " + ex));
                }
            }
            results.close();
        }

        public static boolean resultSetEquivalent(QueryResults rs1, QueryResults rs2) {
            QueryResultsFormatter fmt1 = new QueryResultsFormatter(rs1);
            Model model1 = fmt1.toModel();
            QueryResultsFormatter fmt2 = new QueryResultsFormatter(rs2);
            Model model2 = fmt2.toModel();
            return model1.isIsomorphicWith(model2);
        }

        void runTestConstruct(Query query, QueryExecution qe, long startTime) throws Exception {
        }

        void runTestDescribe(Query query, QueryExecution qe, long startTime) throws Exception {
        }

        void runTestAsk(Query query, QueryExecution qe, long startTime) throws Exception {
        }
    }
}

