/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestResourceFactory
extends TestCase {
    static final String uri1 = "http://example.org/example#a1";
    static final String uri2 = "http://example.org/example#a2";

    public static TestSuite suite() {
        return new TestSuite(TestResourceFactory.class);
    }

    public TestResourceFactory(String name) {
        super(name);
    }

    public void testCreateResource() {
        Resource r1 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)r1.isAnon());
        Resource r2 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)r2.isAnon());
        TestResourceFactory.assertTrue((!r1.equals(r2) ? 1 : 0) != 0);
        r1 = ResourceFactory.createResource((String)uri1);
        TestResourceFactory.assertTrue((boolean)r1.getURI().equals(uri1));
    }

    public void testCreateProperty() {
        Property p1 = ResourceFactory.createProperty((String)uri1);
        TestResourceFactory.assertTrue((boolean)p1.getURI().equals(uri1));
        Property p2 = ResourceFactory.createProperty((String)uri1, (String)"2");
        TestResourceFactory.assertTrue((boolean)p2.getURI().equals("http://example.org/example#a12"));
    }

    public void testCreateStatement() {
        Resource s = ResourceFactory.createResource();
        Property p = ResourceFactory.createProperty((String)uri2);
        Resource o = ResourceFactory.createResource();
        Statement stmt = ResourceFactory.createStatement((Resource)s, (Property)p, (RDFNode)o);
        TestResourceFactory.assertTrue((boolean)stmt.getSubject().equals(s));
        TestResourceFactory.assertTrue((boolean)stmt.getPredicate().equals(p));
        TestResourceFactory.assertTrue((boolean)stmt.getObject().equals(o));
    }

    public void testGetInstance() {
        ResourceFactory.Interface factory = ResourceFactory.getInstance();
        Resource r1 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)r1.isAnon());
        Resource r2 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)r2.isAnon());
        TestResourceFactory.assertTrue((!r1.equals(r2) ? 1 : 0) != 0);
    }

    public void testSetInstance() {
        Resource r = ResourceFactory.createResource();
        TestFactory factory = new TestFactory(r);
        ResourceFactory.setInstance((ResourceFactory.Interface)factory);
        TestResourceFactory.assertTrue((boolean)factory.equals(ResourceFactory.getInstance()));
        TestResourceFactory.assertTrue((ResourceFactory.createResource() == r ? 1 : 0) != 0);
    }

    class TestFactory
    implements ResourceFactory.Interface {
        Resource resource;

        TestFactory(Resource r) {
            this.resource = r;
        }

        public Resource createResource() {
            return this.resource;
        }

        public Resource createResource(String uriref) {
            return null;
        }

        public Literal createPlainLiteral(String string) {
            return null;
        }

        public Property createProperty(String uriref) {
            return null;
        }

        public Property createProperty(String namespace, String localName) {
            return null;
        }

        public Statement createStatement(Resource subject, Property predicate, RDFNode object) {
            return null;
        }
    }
}

