/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ModelTestBase
extends GraphTestBase {
    protected static Model aModel = ModelTestBase.extendedModel();
    protected static final Model empty = ModelFactory.createDefaultModel();

    public ModelTestBase(String name) {
        super(name);
    }

    protected static Model extendedModel() {
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes(PrefixMapping.Extended);
        return result;
    }

    protected static String nice(RDFNode n) {
        return ModelTestBase.nice(n.asNode());
    }

    public static Statement statement(Model m, String fact) {
        StringTokenizer st = new StringTokenizer(fact);
        Resource sub = ModelTestBase.resource(m, st.nextToken());
        Property pred = ModelTestBase.property(m, st.nextToken());
        RDFNode obj = ModelTestBase.rdfNode(m, st.nextToken());
        return m.createStatement(sub, pred, obj);
    }

    public static Statement statement(String fact) {
        return ModelTestBase.statement(aModel, fact);
    }

    public static RDFNode rdfNode(Model m, String s) {
        Node n = Node.create((PrefixMapping)m, (String)s);
        Class clazz = n.isLiteral() ? Literal.class : Resource.class;
        return (RDFNode)((ModelCom)m).getNodeAs(n, clazz);
    }

    protected static Resource resource() {
        return ResourceFactory.createResource();
    }

    public static Resource resource(String s) {
        return ModelTestBase.resource(aModel, s);
    }

    public static Resource resource(Model m, String s) {
        return (Resource)ModelTestBase.rdfNode(m, s);
    }

    public static Property property(String s) {
        return ModelTestBase.property(aModel, s);
    }

    public static Property property(Model m, String s) {
        return (Property)ModelTestBase.rdfNode(m, s, Property.class);
    }

    public static Literal literal(Model m, String s) {
        return (Literal)ModelTestBase.rdfNode(m, s, Literal.class);
    }

    public static RDFNode rdfNode(Model m, String s, Class c) {
        Node n = Node.create((PrefixMapping)m, (String)s);
        return (RDFNode)((ModelCom)m).getNodeAs(n, c);
    }

    public static Statement[] statements(Model m, String facts) {
        ArrayList<Statement> sl = new ArrayList<Statement>();
        StringTokenizer st = new StringTokenizer(facts, ";");
        while (st.hasMoreTokens()) {
            sl.add(ModelTestBase.statement(m, st.nextToken()));
        }
        return sl.toArray(new Statement[sl.size()]);
    }

    public static Resource[] resources(Model m, String items) {
        ArrayList<Resource> rl = new ArrayList<Resource>();
        StringTokenizer st = new StringTokenizer(items);
        while (st.hasMoreTokens()) {
            rl.add(ModelTestBase.resource(m, st.nextToken()));
        }
        return rl.toArray(new Resource[rl.size()]);
    }

    public static Set resourceSet(String items) {
        HashSet<Resource> result = new HashSet<Resource>();
        StringTokenizer st = new StringTokenizer(items);
        while (st.hasMoreTokens()) {
            result.add(ModelTestBase.resource(st.nextToken()));
        }
        return result;
    }

    public static Model modelAdd(Model m, String facts) {
        StringTokenizer semis = new StringTokenizer(facts, ";");
        while (semis.hasMoreTokens()) {
            m.add(ModelTestBase.statement(m, semis.nextToken()));
        }
        return m;
    }

    public static Model modelWithStatements(String facts) {
        return ModelTestBase.modelWithStatements(ReificationStyle.Standard, facts);
    }

    public static Model modelWithStatements(ReificationStyle style, String facts) {
        return ModelTestBase.modelAdd(ModelTestBase.createModel(style), facts);
    }

    public static Model createModel(ReificationStyle style) {
        Model result = ModelFactory.createDefaultModel((ReificationStyle)style);
        result.setNsPrefixes(PrefixMapping.Extended);
        return result;
    }

    public static Model createMemModel() {
        return ModelFactory.createDefaultModel();
    }

    public static void assertIsoModels(String title, Model wanted, Model got) {
        if (!wanted.isIsomorphicWith(got)) {
            Map map = CollectionFactory.createHashedMap();
            ModelTestBase.fail((String)(title + ": expected " + ModelTestBase.nice(wanted.getGraph(), map) + "\n but had " + ModelTestBase.nice(got.getGraph(), map)));
        }
    }

    public static void assertIsoModels(Model wanted, Model got) {
        ModelTestBase.assertIsoModels("models must be isomorphic", wanted, got);
    }
}

