/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.spec.test;

import com.hp.hpl.jena.db.impl.DriverMap;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.RDBMakerCreator;
import com.hp.hpl.jena.rdf.model.impl.RDBModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import junit.framework.TestSuite;

public class TestModelSpecRDB
extends ModelTestBase {
    public TestModelSpecRDB(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecRDB.class);
    }

    public void testSpecExists() {
        Model d = TestModelSpecRDB.modelWithStatements("");
        Resource r = d.createResource("");
        RDBModelSpec ms = new RDBModelSpec(r, d);
    }

    public void testCreatorExists() {
        Model d = TestModelSpecRDB.modelWithStatements("");
        Resource r = TestModelSpecRDB.resource(d, "_x");
        ModelSpecCreator c = ModelSpecCreatorRegistry.instance.getCreator(JenaModelSpec.RDBModelSpec);
        ModelSpec x = c.create(r, d);
        TestModelSpecRDB.assertTrue((boolean)(x instanceof RDBModelSpec));
    }

    public void testExplicitClassName() {
        Model d = TestModelSpecRDB.modelWithStatements("_x rdf:type jms:RDBModelSpec");
        Resource r = TestModelSpecRDB.resource(d, "_x");
        Model m = TestModelSpecRDB.modelWithStatements("_x jms:dbClass 'some.fake.class'");
        String name = RDBMakerCreator.getClassName((Model)m, (Resource)TestModelSpecRDB.resource("_x"));
        TestModelSpecRDB.assertEquals((String)"some.fake.class", (String)name);
    }

    public void testImpliedClassName() {
        Model m = TestModelSpecRDB.modelWithStatements("_x jms:dbType 'mysql'");
        String name = RDBMakerCreator.getClassName((Model)m, (Resource)TestModelSpecRDB.resource("_x"));
        TestModelSpecRDB.assertEquals((String)DriverMap.get((String)"mysql"), (String)name);
    }
}

