/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.spec.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecCreatorByClassname;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.rdf.model.spec.test.MockModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.shared.NotFoundException;
import junit.framework.TestSuite;

public class TestModelSpecFactory
extends ModelTestBase {
    protected ModelSpecCreator createMock = new ModelSpecCreator(){

        public ModelSpec create(Resource root, Model desc) {
            return new MockModelSpec(root, desc);
        }
    };

    public TestModelSpecFactory(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecFactory.class);
    }

    public void testFindUniqueRootByType() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:x rdf:type eh:T; eh:y rdf:type eh:U");
        TestModelSpecFactory.assertEquals((Object)TestModelSpecFactory.resource("eh:x"), (Object)ModelSpecFactory.findRootByType((Model)m, (Resource)TestModelSpecFactory.resource("eh:T")));
    }

    public void testFindMissingRootByType() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:y rdf:type eh:U");
        Resource type = TestModelSpecFactory.resource("eh:T");
        try {
            ModelSpecFactory.findRootByType((Model)m, (Resource)type);
            TestModelSpecFactory.fail((String)"should trap missing root");
        }
        catch (BadDescriptionNoRootException e) {
            TestModelSpecFactory.assertEquals((Object)type, (Object)e.type);
            TestModelSpecFactory.assertSame((Object)m, (Object)e.badModel);
        }
    }

    public void testFindMultipleRootByType() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:x rdf:type eh:T; eh:y rdf:type eh:T");
        Resource type = TestModelSpecFactory.resource("eh:T");
        try {
            ModelSpecFactory.findRootByType((Model)m, (Resource)type);
            TestModelSpecFactory.fail((String)"should trap multiple roots");
        }
        catch (BadDescriptionMultipleRootsException e) {
            TestModelSpecFactory.assertEquals((Object)type, (Object)e.type);
            TestModelSpecFactory.assertSame((Object)m, (Object)e.badModel);
        }
    }

    public void testFindSpecificTypeTrivial() {
        Model m = this.fullModel("eh:root rdf:type eh:T");
        Resource T = TestModelSpecFactory.resource("eh:T");
        Resource root = m.createResource("eh:root");
        TestModelSpecFactory.assertEquals((Object)T, (Object)ModelSpecFactory.findSpecificType((Resource)root, (Resource)T));
    }

    public void testFindSpecificTypeWithIrrelevantOtherType() {
        Model m = this.fullModel("eh:root rdf:type eh:T; eh:root rdf:type eh:Other");
        Resource T = TestModelSpecFactory.resource("eh:T");
        Resource root = m.createResource("eh:root");
        TestModelSpecFactory.assertEquals((Object)T, (Object)ModelSpecFactory.findSpecificType((Resource)root, (Resource)T));
    }

    public void testFactoryReturnsAModelSpec() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        Resource r = m.createResource("eh:Root");
        ModelSpec s = ModelSpecFactory.createSpec((Model)m, (Resource)r);
    }

    public void testModelAccessible() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        Resource r = m.createResource("eh:Root");
        ModelSpec g = ModelSpecFactory.createSpec((Model)m, (Resource)r);
        TestModelSpecFactory.assertNotNull((Object)g.getDescription());
    }

    public void testFactoryNoRoot() {
        Model m = TestModelSpecFactory.modelWithStatements("");
        try {
            ModelSpecFactory.createSpec((Model)m);
        }
        catch (BadDescriptionException e) {
            TestModelSpecFactory.pass();
        }
    }

    public void testGEMSmultipleRoots() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:ModelSpec; eh:Fake rdf:type jms:PlainModelSpec");
        try {
            ModelSpecFactory.createSpec((Model)m);
        }
        catch (BadDescriptionException e) {
            TestModelSpecFactory.pass();
        }
    }

    public void testDefaultCreate() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        ModelSpec s = ModelSpecFactory.createSpec((Model)m);
        Model x = s.createFreshModel();
        TestModelSpecFactory.assertNotNull((Object)x);
    }

    public void testMatchingModelSpec() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        ModelSpec s = ModelSpecFactory.createSpec((Model)m);
    }

    public void testLoadsCorrectModelSpec() {
        Model m = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type eh:MockSpec; eh:MockSpec rdfs:subClassOf jms:ModelSpec");
        ModelSpec s = ModelSpecFactory.createSpec((ModelSpecCreatorRegistry)ModelSpecCreatorRegistry.registryWith((Resource)TestModelSpecFactory.resource("eh:MockSpec"), (ModelSpecCreator)this.createMock), (Model)m);
        TestModelSpecFactory.assertInstanceOf(MockModelSpec.class, s);
    }

    public void testCreateCreator() {
        String className = "com.hp.hpl.jena.rdf.model.spec.test.MockModelSpec";
        ModelSpecCreatorByClassname c = new ModelSpecCreatorByClassname(className);
        ModelSpec s = c.create(TestModelSpecFactory.resource("root"), TestModelSpecFactory.modelWithStatements(""));
        TestModelSpecFactory.assertEquals((String)className, (String)s.getClass().getName());
    }

    public void testCreateCreatorDeferred() {
        String className = "lets.go.gathering.nuts.in.May";
        ModelSpecCreatorByClassname c = new ModelSpecCreatorByClassname(className);
    }

    public void testRegistryDetectsMissingConfig() {
        try {
            new ModelSpecCreatorRegistry("there/is/no/such/config.file");
            TestModelSpecFactory.fail((String)"there should be no such configuration file found");
        }
        catch (NotFoundException e) {
            TestModelSpecFactory.pass();
        }
    }

    public void testRegistryIgnoresMissingConfig() {
        new ModelSpecCreatorRegistry("there/is/no/such/config.file", true);
    }

    public void testRegistryDetectSuppliedConfig() {
        Model model = TestModelSpecFactory.modelWithStatements("");
        Resource root = model.createResource("eh:pseudo-modelspec-type");
        ModelSpec s = new ModelSpecCreatorRegistry("testing/modelspecs/modelspec-config.n3").getCreator(TestModelSpecFactory.resource("eh:pseudo-modelspec-type")).create(root, model);
        TestModelSpecFactory.assertInstanceOf(MockModelSpec.class, s);
    }

    protected Model fullModel(String statements) {
        return ModelSpecFactory.withSchema((Model)TestModelSpecFactory.modelWithStatements(statements));
    }
}

