/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.test.ExceptionTests;
import com.hp.hpl.jena.rdf.arp.test.MoreDOM2RDFTest;
import com.hp.hpl.jena.rdf.arp.test.TestErrorMsg;
import com.hp.hpl.jena.rdf.arp.test.TestPropEltErrorMsg;
import com.hp.hpl.jena.rdf.arp.test.TestScope;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MoreTests
extends TestCase
implements RDFErrorHandler,
ARPErrorNumbers {
    private static Log logger = LogFactory.getLog((Class)MoreTests.class);
    private int[] expected;

    public static Test suite() {
        TestSuite suite = new TestSuite("ARP Plus");
        suite.addTest(TestErrorMsg.suite());
        suite.addTest(TestPropEltErrorMsg.suite());
        suite.addTest(TestScope.suite());
        suite.addTest(ExceptionTests.suite());
        suite.addTest((Test)new MoreDOM2RDFTest("testDOMwithARP"));
        suite.addTest((Test)new MoreTests("testIcu"));
        suite.addTest((Test)new MoreTests("testLatin1"));
        suite.addTest((Test)new MoreTests("testIcu2"));
        suite.addTest((Test)new MoreTests("testEncodingMismatch1"));
        suite.addTest((Test)new MoreTests("testEncodingMismatch2"));
        suite.addTest((Test)new MoreTests("testNullBaseParamOK"));
        suite.addTest((Test)new MoreTests("testNullBaseParamError"));
        suite.addTest((Test)new MoreTests("testEmptyBaseParamOK"));
        suite.addTest((Test)new MoreTests("testEmptyBaseParamError"));
        suite.addTest((Test)new MoreTests("testBadBaseParamOK"));
        suite.addTest((Test)new MoreTests("testBadBaseParamError"));
        suite.addTest((Test)new MoreTests("testRelativeBaseParamOK"));
        suite.addTest((Test)new MoreTests("testRelativeBaseParamError"));
        suite.addTest((Test)new MoreTests("testBaseTruncation"));
        suite.addTest((Test)new MoreTests("testWineDefaultNS"));
        suite.addTest((Test)new MoreTests("testInterrupt"));
        suite.addTest((Test)new MoreTests("testDanBriXMLBase"));
        suite.addTest((Test)new MoreTests("testToString"));
        return suite;
    }

    public MoreTests(String s) {
        super(s);
    }

    protected Model createMemModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testWineDefaultNS() throws IOException {
        this.testWineNS(this.createMemModel());
        this.testWineNS((Model)ModelFactory.createOntologyModel());
    }

    private void testWineNS(Model m) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream("testing/arp/xmlns/wine.rdf");
        m.read((InputStream)in, "");
        ((InputStream)in).close();
        MoreTests.assertEquals((String)"http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#", (String)m.getNsPrefixURI(""));
    }

    public void testLatin1() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/latin1.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{134};
        rdr.read(m, (InputStream)r, "http://example.org/");
        this.checkExpected();
    }

    public void testARPMacRoman() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/macroman.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{132, 133};
        this.expected[Charset.isSupported((String)"MacRoman") ? 0 : 1] = 0;
        rdr.read(m, (InputStream)r, "http://example.org/");
        this.checkExpected();
    }

    public void testARPMacArabic() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/arabic-macarabic.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{132, 133};
        this.expected[Charset.isSupported((String)"MacArabic") ? 0 : 1] = 0;
        rdr.read(m, (InputStream)r, "http://example.org/");
        this.checkExpected();
    }

    public void testEncodingMismatch1() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileReader r = new FileReader("testing/wg/rdfms-syntax-incomplete/test001.rdf");
        if (r.getEncoding().startsWith("UTF")) {
            System.err.println("WARNING: Encoding mismatch tests not executed on platform with default UTF encoding.");
            return;
        }
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{129};
        rdr.read(m, (Reader)r, "http://example.org/");
        this.checkExpected();
    }

    public void testIcu() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/icubug.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{121};
        rdr.read(m, (InputStream)r, "http://example.org/");
        r.close();
        this.checkExpected();
    }

    public void testIcu2() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/icubugtwo.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{131};
        rdr.read(m, (InputStream)r, "http://example.org/");
        r.close();
        this.checkExpected();
    }

    public void testToString() throws IOException, SAXException {
        String testcase = "<rdf:RDF xmlns:music=\"http://www.kanzaki.com/ns/music#\"   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"> <rdf:Description>   <music:performs rdf:nodeID=\"p1\"/> </rdf:Description> <rdf:Description rdf:nodeID=\"p1\">   <music:opus>op.26</music:opus> </rdf:Description> </rdf:RDF>";
        ARP parser = new ARP();
        ToStringStatementHandler tssh = new ToStringStatementHandler();
        parser.getHandlers().setStatementHandler((StatementHandler)tssh);
        parser.load((Reader)new StringReader(testcase), "http://www.example.com");
        MoreTests.assertEquals((String)tssh.subj, (String)tssh.obj);
    }

    public void testEncodingMismatch2() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileReader r = new FileReader("testing/wg/rdf-charmod-literals/test001.rdf");
        if (r.getEncoding().startsWith("UTF")) {
            return;
        }
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{129, 210, 210};
        rdr.read(m, (Reader)r, "http://example.org/");
        this.checkExpected();
    }

    public void testNullBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[0];
        rdr.read(m, (InputStream)fin, "http://example.org/");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, (InputStream)fin, null);
        fin.close();
        MoreTests.assertTrue((String)"Base URI should have no effect.", (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testDanBriXMLBase() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        FileInputStream fin = new FileInputStream("testing/arp/xmlbase/danbri.rdf");
        m.read((InputStream)fin, "http://wrong.example.org/");
        fin.close();
        fin = new FileInputStream("testing/arp/xmlbase/danbri.nt");
        m1.read((InputStream)fin, "http://wrong.example.org/", "N-TRIPLE");
        fin.close();
        MoreTests.assertTrue((String)"Dan Bri nested XML Base.", (boolean)m.isIsomorphicWith(m1));
    }

    public void testNullBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{211, 136};
        rdr.read(m, (InputStream)fin, null);
        fin.close();
        this.checkExpected();
    }

    public void testEmptyBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[0];
        rdr.read(m, (InputStream)fin, "http://example.org/");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, (InputStream)fin, "");
        fin.close();
        MoreTests.assertTrue((String)("Empty base URI should have no effect.[" + m1.toString() + "]"), (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testEmptyBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{130};
        rdr.read(m, (InputStream)fin, "");
        fin.close();
        Model m1 = this.createMemModel();
        m1.createResource("#foo").addProperty(RDF.value, "abc");
        MoreTests.assertTrue((String)("Empty base URI should produce relative URI.[" + m.toString() + "]"), (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testBadBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{107, 107, 214};
        rdr.read(m, (InputStream)fin, "http://jjc^3.org/demo.mp3");
        fin.close();
        Model m1 = this.createMemModel();
        MoreTests.assertTrue((String)("Bad base URI should produce no URIs in model.[" + m.toString() + "]"), (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testBadBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{107};
        rdr.read(m, (InputStream)fin, "http://jjc^3.org/demo.mp3");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, (InputStream)fin, "");
        fin.close();
        MoreTests.assertTrue((String)("Bad base URI should have no effect on model.[" + m1.toString() + "]"), (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testRelativeBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{136, 136, 215};
        rdr.setProperty("ERR_RESOLVING_AGAINST_RELATIVE_BASE", (Object)"EM_WARNING");
        rdr.read(m, (InputStream)fin, "foo/");
        fin.close();
        Model m1 = this.createMemModel();
        m1.createResource("foo/#foo").addProperty(RDF.value, "abc");
        MoreTests.assertTrue((String)("Relative base URI should produce relative URIs in model (when error suppressed).[" + m.toString() + "]"), (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testRelativeBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{136};
        rdr.read(m, (InputStream)fin, "foo/");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, (InputStream)fin, "");
        fin.close();
        MoreTests.assertTrue((String)("Bad base URI should have no effect on model.[" + m1.toString() + "]"), (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testBaseTruncation() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler((RDFErrorHandler)this);
        this.expected = new int[]{107, 136};
        rdr.read(m, (InputStream)fin, "ht#tp://jjc3.org/demo.mp3#frag");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, (InputStream)fin, "");
        fin.close();
        MoreTests.assertTrue((String)("Bad base URI should have no effect.[" + m1.toString() + "]"), (boolean)m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterrupt() throws SAXException, IOException {
        ARP a = new ARP();
        FileInputStream in = new FileInputStream("testing/wg/miscellaneous/consistent001.rdf");
        a.getHandlers().setStatementHandler(new StatementHandler(){
            int countDown = 10;

            public void statement(AResource subj, AResource pred, AResource obj) {
                if (this.countDown-- == 0) {
                    Thread.currentThread().interrupt();
                }
            }

            public void statement(AResource subj, AResource pred, ALiteral lit) {
            }
        });
        a.getHandlers().setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                throw new RuntimeException("Unexpected error", exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                throw new RuntimeException("Unexpected warning", exception);
            }
        });
        try {
            a.load((InputStream)in);
            MoreTests.fail((String)"Thread was not interrupted.");
        }
        catch (InterruptedIOException e) {
        }
        catch (SAXParseException sAXParseException) {
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private void checkExpected() {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] == 0) continue;
            MoreTests.fail((String)("Expected error: " + ParseException.errorCodeName((int)this.expected[i]) + " but it did not occur."));
        }
    }

    public void warning(Exception e) {
        this.error(0, e);
    }

    public void error(Exception e) {
        this.error(1, e);
    }

    public void fatalError(Exception e) {
        this.error(2, e);
    }

    private void error(int level, Exception e) {
        if (e instanceof ParseException) {
            int eCode = ((ParseException)e).getErrorNumber();
            this.onError(level, eCode);
        } else {
            MoreTests.fail((String)("Not expecting an Exception: " + e.getMessage()));
        }
    }

    private void println(String m) {
        logger.error((Object)m);
    }

    void onError(int level, int num) {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] != num) continue;
            this.expected[i] = 0;
            return;
        }
        String msg = "Parser reports unexpected " + WGTestSuite.errorLevelName[level] + ": " + ParseException.errorCodeName((int)num);
        this.println(msg);
        MoreTests.fail((String)msg);
    }

    static class ToStringStatementHandler
    implements StatementHandler {
        String obj;
        String subj;

        ToStringStatementHandler() {
        }

        public void statement(AResource sub, AResource pred, ALiteral lit) {
            this.subj = sub.toString();
        }

        public void statement(AResource sub, AResource pred, AResource ob) {
            this.obj = ob.toString();
        }
    }
}

