/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;

public class TestOntClass
extends ModelTestBase {
    private static final String NS = "http://example.com/test#";

    public TestOntClass(String name) {
        super(name);
    }

    public void testSuperClassNE() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        TestOntClass.assertNull((Object)a.getSuperClass());
        TestOntClass.assertFalse((boolean)a.hasSuperClass());
    }

    public void testSubClassNE() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        TestOntClass.assertNull((Object)a.getSubClass());
        TestOntClass.assertFalse((boolean)a.hasSubClass());
    }

    public void testCreateIndividual() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        Individual i = a.createIndividual("http://example.com/test#i");
        TestOntClass.assertTrue((boolean)i.hasRDFType((Resource)a));
        Individual j = a.createIndividual();
        TestOntClass.assertTrue((boolean)j.hasRDFType((Resource)a));
    }

    public void testIsHierarchyRoot0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot1() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot2() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot3() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_TRANS_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot4() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot5() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot6() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot7() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM_RULE_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot8() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot9() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_RDFS_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass((Resource)b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }
}

