/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.ArrayBunch;
import com.hp.hpl.jena.mem.TripleBunch;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class TestTripleBunch
extends GraphTestBase {
    protected static final Triple tripleSPO = TestTripleBunch.triple("s P o");
    protected static final Triple tripleXQY = TestTripleBunch.triple("x Q y");
    protected static final TripleBunch emptyBunch = new ArrayBunch();

    public TestTripleBunch(String name) {
        super(name);
    }

    protected abstract TripleBunch getBunch();

    public void testEmptyBunch() {
        TripleBunch b = this.getBunch();
        TestTripleBunch.assertEquals((int)0, (int)b.size());
        TestTripleBunch.assertFalse((boolean)b.contains(tripleSPO));
        TestTripleBunch.assertFalse((boolean)b.contains(tripleXQY));
        TestTripleBunch.assertFalse((boolean)b.iterator().hasNext());
    }

    public void testAddElement() {
        TripleBunch b = this.getBunch();
        b.add(tripleSPO);
        TestTripleBunch.assertEquals((int)1, (int)b.size());
        TestTripleBunch.assertTrue((boolean)b.contains(tripleSPO));
        TestTripleBunch.assertEquals((Object)this.listOf(tripleSPO), (Object)TestTripleBunch.iteratorToList((Iterator)b.iterator()));
    }

    public void testAddElements() {
        TripleBunch b = this.getBunch();
        b.add(tripleSPO);
        b.add(tripleXQY);
        TestTripleBunch.assertEquals((int)2, (int)b.size());
        TestTripleBunch.assertTrue((boolean)b.contains(tripleSPO));
        TestTripleBunch.assertTrue((boolean)b.contains(tripleXQY));
        TestTripleBunch.assertEquals((Object)this.setOf(tripleSPO, tripleXQY), (Object)TestTripleBunch.iteratorToSet((Iterator)b.iterator()));
    }

    public void testRemoveOnlyElement() {
        TripleBunch b = this.getBunch();
        b.add(tripleSPO);
        b.remove(tripleSPO);
        TestTripleBunch.assertEquals((int)0, (int)b.size());
        TestTripleBunch.assertFalse((boolean)b.contains(tripleSPO));
        TestTripleBunch.assertFalse((boolean)b.iterator().hasNext());
    }

    public void testRemoveFirstOfTwo() {
        TripleBunch b = this.getBunch();
        b.add(tripleSPO);
        b.add(tripleXQY);
        b.remove(tripleSPO);
        TestTripleBunch.assertEquals((int)1, (int)b.size());
        TestTripleBunch.assertFalse((boolean)b.contains(tripleSPO));
        TestTripleBunch.assertTrue((boolean)b.contains(tripleXQY));
        TestTripleBunch.assertEquals((Object)this.listOf(tripleXQY), (Object)TestTripleBunch.iteratorToList((Iterator)b.iterator()));
    }

    public void testTableGrows() {
        TripleBunch b = this.getBunch();
        b.add(tripleSPO);
        b.add(tripleXQY);
        b.add(TestTripleBunch.triple("a I b"));
        b.add(TestTripleBunch.triple("c J d"));
    }

    protected List listOf(Triple x) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        result.add(x);
        return result;
    }

    protected Set setOf(Triple x, Triple y) {
        Set result = this.setOf(x);
        result.add(y);
        return result;
    }

    protected Set setOf(Triple x) {
        HashSet<Triple> result = new HashSet<Triple>();
        result.add(x);
        return result;
    }
}

