/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestGraphMem
extends AbstractTestGraph {
    public TestGraphMem(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGraphMem.class);
    }

    public Graph getGraph() {
        return Factory.createGraphMem();
    }

    public void testClosesReifier() {
        Graph g = this.getGraph();
        SimpleReifier r = (SimpleReifier)g.getReifier();
        g.close();
        TestGraphMem.assertTrue((boolean)r.isClosed());
    }

    public void testBrokenIndexes() {
        Graph g = this.getGraphWith("x R y; x S z");
        ExtendedIterator it = g.find(Node.ANY, Node.ANY, Node.ANY);
        it.removeNext();
        it.removeNext();
        TestGraphMem.assertFalse((boolean)g.find(TestGraphMem.node("x"), Node.ANY, Node.ANY).hasNext());
        TestGraphMem.assertFalse((boolean)g.find(Node.ANY, TestGraphMem.node("R"), Node.ANY).hasNext());
        TestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, TestGraphMem.node("y")).hasNext());
    }

    public void testBrokenSubject() {
        Graph g = this.getGraphWith("x brokenSubject y");
        ExtendedIterator it = g.find(TestGraphMem.node("x"), Node.ANY, Node.ANY);
        it.removeNext();
        TestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testBrokenPredicate() {
        Graph g = this.getGraphWith("x brokenPredicate y");
        ExtendedIterator it = g.find(Node.ANY, TestGraphMem.node("brokenPredicate"), Node.ANY);
        it.removeNext();
        TestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testBrokenObject() {
        Graph g = this.getGraphWith("x brokenObject y");
        ExtendedIterator it = g.find(Node.ANY, Node.ANY, TestGraphMem.node("y"));
        it.removeNext();
        TestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testRemoveAllDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestGraphMem.graphAdd((Graph)g, "x P y; a Q b");
        g.getBulkUpdateHandler().removeAll();
        TestGraphMem.assertEquals((int)0, (int)g.size());
    }

    public void testSizeAfterRemove() {
        Graph g = this.getGraphWith("x p y");
        ExtendedIterator it = g.find((TripleMatch)TestGraphMem.triple("x ?? ??"));
        it.removeNext();
        TestGraphMem.assertEquals((int)0, (int)g.size());
    }

    public void testContainsConcreteDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestGraphMem.graphAdd((Graph)g, "x P y; a Q b");
        TestGraphMem.assertTrue((boolean)g.contains(TestGraphMem.triple("x P y")));
        TestGraphMem.assertTrue((boolean)g.contains(TestGraphMem.triple("a Q b")));
        TestGraphMem.assertFalse((boolean)g.contains(TestGraphMem.triple("a P y")));
        TestGraphMem.assertFalse((boolean)g.contains(TestGraphMem.triple("y R b")));
    }

    public void testUnnecessaryMatches() {
        Node_URI special = new Node_URI("eg:foo"){

            public boolean matches(Node s) {
                Assert.fail((String)"Matched called superfluously.");
                return true;
            }
        };
        Graph g = this.getGraphWith("x p y");
        g.add(new Triple((Node)special, (Node)special, (Node)special));
        this.exhaust((Iterator)g.find((Node)special, Node.ANY, Node.ANY));
        this.exhaust((Iterator)g.find(Node.ANY, (Node)special, Node.ANY));
        this.exhaust((Iterator)g.find(Node.ANY, Node.ANY, (Node)special));
    }

    protected void exhaust(Iterator it) {
        while (it.hasNext()) {
            it.next();
        }
    }

    protected final class GraphMemWithoutFind
    extends GraphMem {
        protected GraphMemWithoutFind() {
        }

        public ExtendedIterator graphBaseFind(TripleMatch t) {
            throw new JenaException("find is Not Allowed");
        }
    }
}

