/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.PatternLiteral;
import com.hp.hpl.jena.graph.query.Rewrite;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import junit.framework.TestSuite;

public class TestExpressions
extends QueryTestBase {
    public TestExpressions(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestExpressions.class);
    }

    public void testExpressionPatternLanguages() {
        TestExpressions.assertEquals((String)"http://jena.hpl.hp.com/2003/07/query/RDQL", (String)"http://jena.hpl.hp.com/2003/07/query/RDQL");
    }

    public void testBooleanEquality() {
        TestExpressions.assertEquals((Object)Expression.TRUE, (Object)Expression.TRUE);
        TestExpressions.assertEquals((Object)Expression.FALSE, (Object)Expression.FALSE);
        TestExpressions.assertDiffer(Expression.TRUE, Expression.FALSE);
        TestExpressions.assertDiffer(Expression.FALSE, Expression.TRUE);
    }

    public void testDyadicEquality() {
        Expression A = this.lit("Aaa");
        Expression B = this.lit("Bee");
        TestExpressions.assertDiffer(A, B);
        TestExpressions.assertEquals((Object)this.contains(A, "groo"), (Object)this.contains(A, "groo"));
        TestExpressions.assertEquals((Object)this.contains(B, "oops"), (Object)this.contains(B, "oops"));
        TestExpressions.assertDiffer(this.contains(A, "groo"), this.contains(A, "glue"));
        TestExpressions.assertDiffer(this.contains(A, "groo"), this.contains(B, "groo"));
        TestExpressions.assertDiffer(this.contains(A, "blue"), this.startsWith(A, "blue"));
        TestExpressions.assertDiffer(this.contains(A, "blue"), this.endsWith(A, "blue"));
        TestExpressions.assertDiffer(this.endsWith(A, "blue"), this.startsWith(A, "blue"));
    }

    public Expression contains(Expression L, PatternLiteral R) {
        return Rewrite.contains((Expression)L, (String)R.getPatternString(), (String)R.getPatternModifiers());
    }

    public Expression contains(Expression L, String R) {
        return Rewrite.contains((Expression)L, (String)R, (String)"");
    }

    public Expression endsWith(Expression L, String R) {
        return Rewrite.endsWith((Expression)L, (String)R, (String)"");
    }

    public Expression endsWith(Expression L, PatternLiteral R) {
        return Rewrite.endsWith((Expression)L, (String)R.getPatternString(), (String)R.getPatternModifiers());
    }

    public Expression startsWith(Expression L, String R) {
        return Rewrite.startsWith((Expression)L, (String)R, (String)"");
    }

    public Expression startsWith(Expression L, PatternLiteral R) {
        return Rewrite.startsWith((Expression)L, (String)R.getPatternString(), (String)R.getPatternModifiers());
    }

    public void testLiterals() {
        TestExpressions.assertTrue((boolean)Expression.TRUE.isConstant());
        TestExpressions.assertTrue((boolean)Expression.FALSE.isConstant());
        TestExpressions.assertEquals((Object)Boolean.TRUE, (Object)Expression.TRUE.getValue());
        TestExpressions.assertEquals((Object)Boolean.FALSE, (Object)Expression.FALSE.getValue());
    }

    public void testPrepareTRUE() {
        Valuator t = Expression.TRUE.prepare((VariableIndexes)emptyMapping);
        TestExpressions.assertEquals((boolean)true, (boolean)t.evalBool(noIVs));
        TestExpressions.assertEquals((Object)Boolean.TRUE, (Object)t.evalObject(noIVs));
    }

    public void testPrepareFALSE() {
        Valuator t = Expression.FALSE.prepare((VariableIndexes)emptyMapping);
        TestExpressions.assertEquals((boolean)false, (boolean)t.evalBool(noIVs));
        TestExpressions.assertEquals((Object)Boolean.FALSE, (Object)t.evalObject(noIVs));
    }

    public void testFixed() {
        this.testFixed("hello");
        this.testFixed("goodbye");
        this.testFixed(Boolean.TRUE);
        this.testFixed(new int[]{17, 27, 42});
    }

    protected void testFixed(Object value) {
        Expression e = this.lit(value);
        TestExpressions.assertEquals((Object)value, (Object)e.getValue());
        TestExpressions.assertEquals((Object)value, (Object)this.evalObject(e));
    }

    public void testDyadic() {
        Expression L = this.lit("a");
        Expression R = this.lit("b");
        Dyadic e = new Dyadic(L, "eh:op", R){

            public Object evalObject(Object x, Object y) {
                return "" + x + "--" + y;
            }
        };
        TestExpressions.assertEquals((int)2, (int)e.argCount());
        TestExpressions.assertSame((Object)L, (Object)e.getArg(0));
        TestExpressions.assertSame((Object)R, (Object)e.getArg(1));
        TestExpressions.assertEquals((String)"eh:op", (String)e.getFun());
        TestExpressions.assertEquals((Object)"a--b", (Object)this.evalObject((Expression)e));
    }

    public void testStartsWith() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("hello"), "h")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("hello"), "he")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("hello"), "hel")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("HELLO"), "hel")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("hello"), "HEL")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("hello"), "e")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("hello"), "llo")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("hello"), "xhe")));
    }

    public void testStartsInsensitiveWith() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("hello"), this.pli("H"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("hEllo"), this.pli("he"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("heLlo"), this.pli("hEl"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("HELLO"), this.pli("hel"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.startsWith(this.lit("hello"), this.pli("HEL"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("hello"), this.pli("e"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("hello"), this.pli("llo"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.startsWith(this.lit("hello"), this.pli("xhe"))));
    }

    public void testIsContains() {
        TestExpressions.assertEquals((boolean)true, (boolean)Rewrite.isContains((PatternLiteral)this.pl("ambulance")));
        TestExpressions.assertEquals((boolean)true, (boolean)Rewrite.isContains((PatternLiteral)this.pl("tendonitis", "i")));
        TestExpressions.assertEquals((boolean)false, (boolean)Rewrite.isContains((PatternLiteral)this.pl("finishing", "z")));
    }

    public void testSensitiveContains() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.lit("hello"), "h")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.lit("hello"), "e")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.lit("hello"), "ll")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("heLLo"), "ll")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("hello"), "LL")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("hello"), "x")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("hello"), "the")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("hello"), "lot")));
    }

    public void testInsensitiveContains() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.lit("Hello"), this.pli("h"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.lit("hello"), this.pli("E"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.lit("heLlo"), this.pli("lL"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("hello"), this.pli("X"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("hello"), this.pli("the"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.lit("hello"), this.pli("lot"))));
    }

    public void testLangedLiteralsEndsWith() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.litString("'spoo'en"), "o")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.litString("'spoo'go"), "o")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.litString("'spot'go"), "o")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.litString("'spot'en"), "o")));
    }

    public void testTypedLiteralsEndsWith() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.litString("'spoo'xsd:mint"), "o")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.litString("'spoo'xsd:gloo"), "o")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.litString("'spot'xsd:slat"), "o")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.litString("'spot'xsd:do"), "o")));
    }

    public void testLangedLiteralsContains() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.litString("'spoo'en"), "po")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.litString("'spoo'go"), "sp")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.litString("'spot'go"), "go")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.litString("'spot'en"), "en")));
    }

    public void testTypedLiteralsContains() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.litString("'spoo'xsd:mint"), "sp")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.contains(this.litString("'spoo'xsd:gloo"), "po")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.litString("'spot'xsd:slat"), "sl")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.contains(this.litString("'spot'xsd:do"), "do")));
    }

    public void testEndsWith() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.lit("hello"), "o")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.lit("hello"), "lo")));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.lit("hello"), "hello")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("HELLO"), "hello")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("hello"), "HELLO")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("hello"), "ll")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("hello"), "hel")));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("hello"), "quantum")));
    }

    public void testInsensitiveEndsWith() {
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.lit("hellO"), this.pli("o"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.lit("hello"), this.pli("lO"))));
        TestExpressions.assertEquals((boolean)true, (boolean)this.evalBool(this.endsWith(this.lit("HeLLo"), this.pli("HELlo"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("hello"), this.pli("ll"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("hello"), this.pli("hel"))));
        TestExpressions.assertEquals((boolean)false, (boolean)this.evalBool(this.endsWith(this.lit("hello"), this.pli("quantum"))));
    }

    private Object evalObject(Expression e) {
        return e.prepare((VariableIndexes)emptyMapping).evalObject(noIVs);
    }

    private boolean evalBool(Expression e) {
        return e.prepare((VariableIndexes)emptyMapping).evalBool(noIVs);
    }

    protected Expression litString(String s) {
        return this.lit(Node.create((String)s));
    }

    protected Expression lit(Object x) {
        return new Expression.Fixed(x);
    }

    protected PatternLiteral pl(String c) {
        return this.pl(c, "");
    }

    protected PatternLiteral pli(String c) {
        return this.pl(c, "i");
    }

    protected PatternLiteral pl(final String c, final String m) {
        return new PatternLiteral(){

            public String getPatternString() {
                return c;
            }

            public String getPatternModifiers() {
                return m;
            }

            public String getPatternLanguage() {
                return "http://jena.hpl.hp.com/2003/07/query/RDQL";
            }
        };
    }
}

