/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.GraphRDBMaker;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestDBSpec
extends ModelTestBase {
    public TestDBSpec(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDBSpec.class);
    }

    public void testCreateFailsUser() {
        try {
            Resource me = ResourceFactory.createResource();
            Model spec = ModelFactory.createDefaultModel().add(me, RDF.type, (RDFNode)JenaModelSpec.RDBMakerSpec);
            ModelMaker maker = ModelSpecImpl.createMaker((Model)spec);
            TestDBSpec.assertTrue((boolean)(maker.getGraphMaker() instanceof GraphRDBMaker));
            TestDBSpec.fail((String)"should not be able to make RDB model from empty specification");
        }
        catch (Exception e) {
            TestDBSpec.pass();
        }
    }

    public void testCreateSuccessUser() throws ClassNotFoundException {
        Resource me = ResourceFactory.createResource();
        Resource con = ResourceFactory.createResource();
        Resource mak = ResourceFactory.createResource();
        String dbType = TestPackage.M_DB;
        String className = TestPackage.M_DBDRIVER_CLASS;
        Model spec = ModelFactory.createDefaultModel().add(me, JenaModelSpec.maker, (RDFNode)mak).add(mak, RDF.type, (RDFNode)JenaModelSpec.RDBMakerSpec).add(mak, JenaModelSpec.hasConnection, (RDFNode)con).add(con, JenaModelSpec.dbUser, TestPackage.M_DB_USER).add(con, JenaModelSpec.dbPassword, TestPackage.M_DB_PASSWD).add(con, JenaModelSpec.dbURL, (RDFNode)TestDBSpec.resource(TestPackage.M_DB_URL)).add(con, JenaModelSpec.dbType, dbType).add(con, JenaModelSpec.dbClass, className);
        ModelMaker maker = ModelSpecImpl.createMaker((Model)spec);
        TestDBSpec.assertTrue((boolean)(maker.getGraphMaker() instanceof GraphRDBMaker));
        maker.openModel("something").close();
        maker.removeModel("something");
        maker.close();
    }

    public void testCreateDBModelSpec() {
        Resource me = ResourceFactory.createResource();
        Resource dbMaker = ResourceFactory.createResource();
        Resource con = ResourceFactory.createResource();
        String dbType = TestPackage.M_DB;
        String className = TestPackage.M_DBDRIVER_CLASS;
        Model spec = ModelFactory.createDefaultModel().add(me, JenaModelSpec.maker, (RDFNode)dbMaker).add(dbMaker, RDF.type, (RDFNode)JenaModelSpec.RDBMakerSpec).add(dbMaker, JenaModelSpec.hasConnection, (RDFNode)con).add(con, JenaModelSpec.dbUser, TestPackage.M_DB_USER).add(con, JenaModelSpec.dbPassword, TestPackage.M_DB_PASSWD).add(con, JenaModelSpec.dbURL, (RDFNode)TestDBSpec.resource(TestPackage.M_DB_URL)).add(con, JenaModelSpec.dbType, dbType).add(con, JenaModelSpec.dbClass, className);
        ModelSpec s = ModelFactory.createSpec((Model)spec);
        Model d = s.createFreshModel();
        TestDBSpec.assertTrue((boolean)(d instanceof ModelRDB));
    }
}

