/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.ModelSourceAssembler;
import com.hp.hpl.jena.assembler.exceptions.PropertyRequiredException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelGetter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.MemoryModelGetter;
import java.util.ArrayList;
import junit.framework.Assert;

public class TestModelSourceAssembler
extends AssemblerTestBase {
    public TestModelSourceAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return ModelSourceAssembler.class;
    }

    public void testModelSourceAssemblerType() {
        this.testDemandsMinimalType((Assembler)new ModelSourceAssembler(), JA.ModelSource);
    }

    public void testModelSourceVocabulary() {
        this.assertDomain(JA.Connectable, JA.connection);
        this.assertRange(JA.Connection, JA.connection);
        this.assertSubclassOf(JA.Connectable, JA.Object);
        this.assertSubclassOf(JA.RDBModelSource, JA.Connectable);
        this.assertSubclassOf(JA.RDBModelSource, JA.ModelSource);
    }

    public void testDBSourceDemandsConnection() {
        Resource root = this.resourceInModel("x rdf:type ja:ModelSource; x rdf:type ja:RDBModelSource");
        ModelSourceAssembler a = new ModelSourceAssembler();
        try {
            a.open(root);
            TestModelSourceAssembler.fail((String)"should catch missing connection");
        }
        catch (PropertyRequiredException e) {
            TestModelSourceAssembler.assertEquals((Object)TestModelSourceAssembler.resource("x"), (Object)e.getRoot());
            TestModelSourceAssembler.assertEquals((Object)JA.connection, (Object)e.getProperty());
        }
    }

    public void testMemModelMakerSource() {
        ModelSourceAssembler a = new ModelSourceAssembler();
        ModelGetter g = (ModelGetter)a.open(this.resourceInModel("mg rdf:type ja:ModelSource"));
        TestModelSourceAssembler.assertInstanceOf(MemoryModelGetter.class, g);
    }

    public void testRDBModelMakerSource() {
        final ConnectionDescription c = new ConnectionDescription("url", "user", "password", "type");
        final ArrayList history = new ArrayList();
        ModelSourceAssembler a = new ModelSourceAssembler(){

            protected ModelGetter createRDBGetter(ConnectionDescription cGiven) {
                Assert.assertSame((Object)c, (Object)cGiven);
                history.add("created");
                return ModelFactory.createMemModelMaker();
            }
        };
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestModelSourceAssembler.resource("C"), c);
        Resource root = this.resourceInModel("mg rdf:type ja:RDBModelSource; mg rdf:type ja:ModelSource; mg ja:connection C");
        TestModelSourceAssembler.assertInstanceOf(ModelGetter.class, a.open((Assembler)mock, root));
        TestModelSourceAssembler.assertEquals((Object)TestModelSourceAssembler.listOfOne("created"), history);
    }
}

