/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.Content;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.ContentAssembler;
import com.hp.hpl.jena.assembler.exceptions.UnknownEncodingException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;

public class TestContentAssembler
extends AssemblerTestBase {
    protected static String Testing = "testing/assemblers";

    public TestContentAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return ContentAssembler.class;
    }

    public void testContentAssemblerType() {
        this.testDemandsMinimalType((Assembler)new ContentAssembler(), JA.Content);
    }

    public void testContentVocabulary() {
        this.assertSubclassOf(JA.Content, JA.Object);
        this.assertSubclassOf(JA.ContentItem, JA.Content);
    }

    public void testContent() {
        ContentAssembler a = new ContentAssembler();
        Content c = (Content)a.open(this.resourceInModel("x rdf:type ja:Content"));
        TestContentAssembler.assertNotNull((Object)c);
        Model m = ModelFactory.createDefaultModel();
        c.fill(m);
        TestContentAssembler.assertEquals((long)0L, (long)m.size());
    }

    public void testMultipleLiteralsWorks() {
        ContentAssembler a = new ContentAssembler();
        String A = "<eh:/A> a <eh:/Type>.".replaceAll(" ", "\\\\s");
        String B = "<eh:/Type> a rdfs:Class.".replaceAll(" ", "\\\\s");
        Resource root = this.resourceInModel("x rdf:type ja:Content; x rdf:type ja:LiteralContent; x ja:literalContent '" + A + "'; x ja:literalContent '" + B + "'");
        Content C = (Content)a.open(root);
        TestContentAssembler.assertIsoModels(this.model("Type rdf:type rdfs:Class; A rdf:type Type"), C.fill(this.model("")));
    }

    public void testN3StringContentSingleTriples() {
        this.testStringContent("_x rdf:value '17'xsd:integer", "_:x rdf:value 17 .");
        this.testStringContent("_x rdf:value '42'xsd:integer", "_:x rdf:value 42 .");
        this.testStringContent("_x rdfs:label 'cosmetic'", "_:x rdfs:label 'cosmetic' .");
        this.testStringContent("_x owl:sameAs spoo", "_:x owl:sameAs <eh:/spoo> .");
        this.testStringContent("_x rdf:value '17'xsd:something", "_:x rdf:value '17'^^xsd:something .");
        this.testStringContent("_x dc:title 'A\\sTitle'", "_:x dc:title 'A Title' .");
    }

    public void testN3StringContentMultipleTriples() {
        this.testStringContent("x rdf:value 5; y owl:sameAs x", "<eh:/x> rdf:value 5 . <eh:/y> owl:sameAs <eh:/x> .");
    }

    public void testRDFXMLContent() {
        ContentAssembler a = new ContentAssembler();
        String Stuff = "<owl:Class></owl:Class>".replaceAll(" ", "\\\\s");
        Resource root = this.resourceInModel("x rdf:type ja:Content; x rdf:type ja:LiteralContent; x ja:literalContent '" + Stuff + "'; x ja:contentEncoding 'RDF/XML'");
        Content c = (Content)a.open(root);
        TestContentAssembler.assertIsoModels(this.model("_x rdf:type owl:Class"), c.fill(this.model("")));
    }

    public void testSingleExternalContent() {
        ContentAssembler a = new ContentAssembler();
        String source = Testing + "/schema.n3";
        Resource root = this.resourceInModel("x rdf:type ja:Content; x rdf:type ja:ExternalContent; x ja:externalContent file:" + source);
        Content c = (Content)a.open(root);
        TestContentAssembler.assertIsoModels(FileManager.get().loadModel("file:" + source), c.fill(this.model("")));
    }

    public void testMultipleExternalContent() {
        ContentAssembler a = new ContentAssembler();
        String sourceA = Testing + "/schema.n3";
        String sourceB = Testing + "/schema2.n3";
        Resource root = this.resourceInModel("x rdf:type ja:Content; x rdf:type ja:ExternalContent; x ja:externalContent file:" + sourceA + "; x ja:externalContent file:" + sourceB);
        Content c = (Content)a.open(root);
        Model wanted = FileManager.get().loadModel("file:" + sourceA).add(FileManager.get().loadModel("file:" + sourceB));
        TestContentAssembler.assertIsoModels(wanted, c.fill(this.model("")));
    }

    public void testIndirectContent() {
        ContentAssembler a = new ContentAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:Content; x ja:content y; y rdf:type ja:Content; y ja:content z; z rdf:type ja:Content; z ja:quotedContent A; A P B");
        Content c = (Content)a.open(root);
        Model wanted = this.model("A P B");
        TestContentAssembler.assertIsoModels(wanted, c.fill(this.model("")));
    }

    public void testTrapsBadEncodings() {
        ContentAssembler a = new ContentAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:Content; x ja:contentEncoding 'bogus'; x ja:literalContent 'sham'");
        try {
            a.open(root);
            TestContentAssembler.fail((String)"should trap bad encoding");
        }
        catch (UnknownEncodingException e) {
            TestContentAssembler.assertEquals((String)"bogus", (String)e.getEncoding());
            TestContentAssembler.assertEquals((Object)TestContentAssembler.resource("x"), (Object)e.getRoot());
        }
    }

    public void testContentTrapsBadObjects() {
        this.testContentTrapsBadObjects("ja:content", "17");
        this.testContentTrapsBadObjects("ja:externalContent", "17");
        this.testContentTrapsBadObjects("ja:quotedContent", "17");
        this.testContentTrapsBadObjects("ja:literalContent", "aResource");
        this.testContentTrapsBadObjects("ja:literalContent", "17");
        this.testContentTrapsBadObjects("ja:literalContent", "'plume'fr");
    }

    private void testContentTrapsBadObjects(String property, String value) {
        ContentAssembler a = new ContentAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:Content; x <property> <value>".replaceAll("<property>", property).replaceAll("<value>", value));
        try {
            a.open(root);
            TestContentAssembler.fail((String)"should trap bad content resource");
        }
        catch (BadObjectException e) {
            TestContentAssembler.assertEquals((Object)TestContentAssembler.resource("x"), (Object)e.getRoot());
            TestContentAssembler.assertEquals((Object)TestContentAssembler.rdfNode(empty, value), (Object)e.getObject());
        }
    }

    public void testMixedContent() {
        ContentAssembler a = new ContentAssembler();
        String source = Testing + "/schema.n3";
        Resource root = this.resourceInModel("x rdf:type ja:Content; x rdf:type ja:LiteralContent; x rdf:type ja:ExternalContent; x ja:literalContent '<eh:/eggs>\\srdf:type\\srdf:Property.'; x ja:externalContent file:" + source);
        Content c = (Content)a.open(root);
        Model wanted = FileManager.get().loadModel("file:" + source).add(this.model("eggs rdf:type rdf:Property"));
        TestContentAssembler.assertIsoModels(wanted, c.fill(this.model("")));
    }

    public void testSingleContentQuotation() {
        ContentAssembler a = new ContentAssembler();
        Resource root = this.resourceInModel("c rdf:type ja:Content; c rdf:type ja:QuotedContent; c ja:quotedContent x; x P A; x Q B");
        Content c = (Content)a.open(root);
        TestContentAssembler.assertIsoModels(this.model("x P A; x Q B"), c.fill(this.model("")));
    }

    public void testMultipleContentQuotation() {
        ContentAssembler a = new ContentAssembler();
        Resource root = this.resourceInModel("c rdf:type ja:Content; c rdf:type ja:QuotedContent; c ja:quotedContent x; c ja:quotedContent y; x P A; x Q B; y R C");
        Content c = (Content)a.open(root);
        TestContentAssembler.assertIsoModels(this.model("x P A; x Q B; y R C"), c.fill(this.model("")));
    }

    public void testContentLoadsPrefixMappings() {
        ContentAssembler a = new ContentAssembler();
        String content = "@prefix foo: <eh:/foo#>. <eh:/eggs> rdf:type rdf:Property.".replaceAll(" ", "\\\\s");
        Resource root = this.resourceInModel("x rdf:type ja:Content; x rdf:type ja:LiteralContent; x ja:literalContent '" + content + "'");
        Content c = (Content)a.open(root);
        Model m = ModelFactory.createDefaultModel();
        c.fill(m);
        TestContentAssembler.assertEquals((String)"eh:/foo#", (String)m.getNsPrefixURI("foo"));
    }

    protected void testStringContent(String expected, String n3) {
        ContentAssembler a = new ContentAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:Content; x rdf:type ja:LiteralContent; x ja:literalContent '" + n3.replaceAll(" ", "\\\\s") + "'");
        Content c = (Content)a.open(root);
        Model m = ModelFactory.createDefaultModel();
        c.fill(m);
        TestContentAssembler.assertIsoModels(this.model(expected), m);
    }
}

