/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees;

import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;

public abstract class Text
extends RegexpTree {
    public static Text create(String s) {
        return s.length() == 1 ? new TextChar(s.charAt(0)) : new TextString(s);
    }

    public static Text create(char ch) {
        return new TextChar(ch);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String getString();

    static class TextChar
    extends Text {
        protected char ch;

        TextChar(char ch) {
            this.ch = ch;
        }

        public String getString() {
            return "" + this.ch;
        }

        public String toString() {
            return "<text.ch '" + this.ch + "'>";
        }

        public boolean equals(Object x) {
            return x instanceof TextChar && this.ch == ((TextChar)x).ch;
        }

        public int hashCode() {
            return this.ch;
        }
    }

    static class TextString
    extends Text {
        protected String literal;

        TextString(String s) {
            this.literal = s;
        }

        public String getString() {
            return this.literal;
        }

        public String toString() {
            return "<text.s '" + this.literal + "'>";
        }

        public boolean equals(Object x) {
            return x instanceof TextString && this.literal.equals(((TextString)x).literal);
        }

        public int hashCode() {
            return this.literal.hashCode();
        }
    }
}

