/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;
import com.hp.hpl.jena.query.util.Utils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestNodeValue
extends TestCase {
    static final double doubleAccuracy = 1.0E-8;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestNodeValue.class);
        ts.setName(Utils.classShortName(TestNodeValue.class));
        return ts;
    }

    public void testInt1() {
        NodeValue v = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    public void testInt2() {
        NodeValue v = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testInt3() {
        NodeValue v1 = NodeValue.makeNodeInteger(5L);
        NodeValue v2 = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Not same integer: " + v1 + " & " + v2), (boolean)v1.getInteger().equals(v2.getInteger()));
    }

    public void testFloat1() {
        NodeValue v = NodeValue.makeFloat(5.0f);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        TestNodeValue.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    public void testFloat2() {
        NodeValue v = NodeValue.makeNodeFloat(5.0f);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testFloat3() {
        NodeValue v1 = NodeValue.makeNodeFloat(5.7f);
        NodeValue v2 = NodeValue.makeFloat(5.7f);
        TestNodeValue.assertTrue((String)("Not same float: " + v1 + " & " + v2), (v1.getFloat() == v2.getFloat() ? 1 : 0) != 0);
        TestNodeValue.assertTrue((String)("Not same float as double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    public void testDouble1() {
        NodeValue v = NodeValue.makeDouble(5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    public void testDouble2() {
        NodeValue v = NodeValue.makeNodeDouble(5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testDouble3() {
        NodeValue v1 = NodeValue.makeNodeDouble(5.7);
        NodeValue v2 = NodeValue.makeDouble(5.7);
        TestNodeValue.assertTrue((String)("Not same double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    public void testDecimal1() {
        NodeValue v = NodeValue.makeDecimal(new BigDecimal("1.3"));
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    public void testDecimal2() {
        NodeValue v = NodeValue.makeNodeDecimal("1.3");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testDecimal3() {
        NodeValue v1 = NodeValue.makeDecimal(new BigDecimal("1.3"));
        NodeValue v2 = NodeValue.makeNodeDecimal("1.3");
        TestNodeValue.assertTrue((String)("Not same decimal: " + v1 + " & " + v2), (v1.getDecimal().compareTo(v2.getDecimal()) == 0 ? 1 : 0) != 0);
        TestNodeValue.assertEquals((String)("Not same decimal by equals: " + v1 + " & " + v2), (Object)v1, (Object)v2);
    }

    public void testDate1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeDate(cal);
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
    }

    public void testDate2() {
        NodeValue v = NodeValue.makeNodeDate("2005-02-18T20:39:10Z");
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testDate3() {
        NodeValue v1 = NodeValue.makeDate("2005-02-18T20:39:10Z");
        NodeValue v2 = NodeValue.makeNodeDate("2005-02-18T20:39:10Z");
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v1.getDate(), (Object)v2.getDate());
    }

    public void testDate4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeNode("2005-02-18T20:39:10Z", XSDDatatype.XSDdateTime);
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        Calendar cal2 = v.getDate();
        TestNodeValue.assertEquals((String)("Not equal: " + v), (Object)cal1, (Object)cal2);
    }

    public void testNodeInt1() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeInt2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeInt3() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57", (String)actualStr);
    }

    public void testNodeInt4() {
        NodeValue v = NodeValue.makeNodeInteger(18L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"18", (String)actualStr);
    }

    public void testNodeInt5() {
        NodeValue v = NodeValue.makeNodeInteger("018");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"018", (String)actualStr);
    }

    public void testNodeFloat1() {
        NodeValue v = NodeValue.makeNode("57.0", XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        TestNodeValue.assertTrue((String)("Not a double(float): " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"57.0\"^^<" + XSDDatatype.XSDfloat.getURI() + ">"), (String)actualStr);
    }

    public void testNodeDouble1() {
        NodeValue v = NodeValue.makeNode("57.0e0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57.0e0", (String)actualStr);
    }

    public void testNodeDouble2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"57\"^^<" + XSDDatatype.XSDdouble.getURI() + ">"), (String)actualStr);
    }

    public void testNodeDouble3() {
        NodeValue v = NodeValue.makeNode("057.0e0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"057.0e0", (String)actualStr);
    }

    public void testNodeBool1() {
        NodeValue v = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        TestNodeValue.assertTrue((String)("Not satisfied: " + v), (boolean)v.getBoolean());
    }

    public void testNodeBool2() {
        NodeValue v = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        TestNodeValue.assertFalse((String)("Satisfied: " + v), (boolean)v.getBoolean());
    }

    public void testNodeBool3() {
        NodeValue v = NodeValue.makeBoolean(true);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not true: " + v), (boolean)v.getBoolean());
        TestNodeValue.assertTrue((String)("Not true: " + v), (boolean)Functions.effectiveBooleanValue(v));
    }

    public void testNodeBool4() {
        NodeValue v = NodeValue.makeBoolean(false);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertFalse((String)("Not false: " + v), (boolean)v.getBoolean());
        TestNodeValue.assertFalse((String)("Not false: " + v), (boolean)Functions.effectiveBooleanValue(v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial1() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger("abc");
            TestNodeValue.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            TestNodeValue.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial2() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger("1.8");
            TestNodeValue.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            TestNodeValue.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial3() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeDate("2005-10-34T00:00:01Z");
            TestNodeValue.assertFalse((String)("Good date: " + v), (boolean)v.isDate());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial4() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            String s = "2005-10-14T 09:30:23+01:00";
            NodeValue.VerboseWarnings = false;
            NodeValue v1 = NodeValue.makeDate(s);
            TestNodeValue.assertFalse((String)("Good date: " + v1), (boolean)v1.isDate());
            s = s.replaceAll(" ", "");
            NodeValue v2 = NodeValue.makeDate(s);
            TestNodeValue.assertTrue((String)("Bad date: " + v2), (boolean)v2.isDate());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    public void testEBV1() {
        TestNodeValue.assertTrue((String)"Not a boolean", (boolean)NodeValue.TRUE.isBoolean());
        TestNodeValue.assertTrue((String)"Not true", (boolean)NodeValue.TRUE.getBoolean());
        TestNodeValue.assertTrue((String)"Not true", (boolean)Functions.effectiveBooleanValue(NodeValue.TRUE));
    }

    public void testEBV2() {
        TestNodeValue.assertTrue((String)"Not a boolean", (boolean)NodeValue.FALSE.isBoolean());
        TestNodeValue.assertFalse((String)"Not false", (boolean)NodeValue.FALSE.getBoolean());
        TestNodeValue.assertFalse((String)"Not false", (boolean)Functions.effectiveBooleanValue(NodeValue.FALSE));
    }

    public void testEBV3() {
        NodeValue v = NodeValue.makeInteger(1L);
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertTrue((String)("Not EBV true: " + v), (boolean)Functions.effectiveBooleanValue(v));
    }

    public void testEBV4() {
        NodeValue v = NodeValue.makeInteger(0L);
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse((String)("Not EBV false: " + v), (boolean)Functions.effectiveBooleanValue(v));
    }

    public void testEBV5() {
        NodeValue v = NodeValue.makeString("xyz");
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertTrue((String)("Not EBV true: " + v), (boolean)Functions.effectiveBooleanValue(v));
    }

    public void testEBV6() {
        NodeValue v = NodeValue.makeString("");
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse((String)("Not EBV false: " + v), (boolean)Functions.effectiveBooleanValue(v));
    }

    public void testFloatDouble1() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.5");
        NodeValue v2 = NodeValue.makeNode("1.5", XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)"Should be equal: 1.5 float and 1.5 double", (boolean)NodeValue.sameValueAs(v1, v2));
    }

    public void testFloatDouble5() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.3");
        NodeValue v2 = NodeValue.makeNode("1.3", XSDDatatype.XSDfloat);
        TestNodeValue.assertFalse((String)"Should not be equal: 1.3 float and 1.3 double", (boolean)NodeValue.sameValueAs(v1, v2));
    }

    public void testString1() {
        NodeValue v = NodeValue.makeString("string");
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeString1() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeString2() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"\"string\"", (String)actualStr);
    }

    public void testNodeString3() {
        NodeValue v = NodeValue.makeNode("string", XSDDatatype.XSDstring);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"string\"^^<" + XSDDatatype.XSDstring.getURI() + ">"), (String)actualStr);
    }

    public void testSameValue1() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeInteger(7L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv3));
    }

    public void testSameValue2() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeNodeInteger(7L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv3));
    }

    public void testSameValue3() {
        NodeValue nv1 = NodeValue.makeDecimal("1.5");
        NodeValue nv2 = NodeValue.makeDecimal("1.6");
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDecimal("1.50");
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv3));
    }

    public void testSameValue4() {
        NodeValue nv1 = NodeValue.makeDecimal("3");
        NodeValue nv2 = NodeValue.makeInteger(4L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeInteger(3L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv3));
    }

    public void testSameValue5() {
        NodeValue nv1 = NodeValue.makeDecimal("-1.5");
        NodeValue nv2 = NodeValue.makeDouble(1.5);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDouble(-1.5);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv3));
    }

    public void testSameValue6() {
        NodeValue nv1 = NodeValue.makeNodeInteger(17L);
        NodeValue nv2 = NodeValue.makeDouble(34.0);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDouble(17.0);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv3));
    }

    public void testSameValue7() {
        NodeValue nv1 = NodeValue.makeBoolean(true);
        NodeValue nv2 = NodeValue.makeString("a");
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeNodeBoolean(true);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameValueAs(nv1, nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameValueAs(nv1, nv3));
    }

    public void testEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals3() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeInteger(1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals4() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode(Node.createURI((String)"http://example"));
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testNotEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }

    public void testNotEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeString("1");
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }

    public void testNotEquals3() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode(Node.createLiteral((String)"http://example"));
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }
}

