/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.Iterator;
import java.util.List;

public abstract class FormatterBase {
    IndentedWriter out;
    SerializationContext context;

    FormatterBase(IndentedWriter _out, SerializationContext _context) {
        this.out = _out;
        this.context = _context;
    }

    public void startVisit() {
    }

    public void finishVisit() {
        this.out.flush();
    }

    protected void formatTriples(List triples) {
        boolean first = true;
        Iterator iter = triples.iterator();
        while (iter.hasNext()) {
            if (!first) {
                this.out.println();
            }
            Triple t = (Triple)iter.next();
            this.formatTriple(t);
            this.out.print(" .");
            first = false;
        }
    }

    protected void formatTriple(Triple tp) {
        this.out.print(this.slotToString(this.context, tp.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, tp.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, tp.getObject()));
    }

    protected String slotToString(SerializationContext context, Node n) {
        return FmtUtils.stringForNode(n, context);
    }
}

