/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.resultset.ResultSetProcessor;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.Iterator;

public class ResultSetApply {
    ResultSetProcessor proc = null;
    ResultSet rs = null;

    public ResultSetApply(ResultSet rs, ResultSetProcessor proc) {
        this.proc = proc;
        this.rs = rs;
    }

    public void apply() {
        this.proc.start(this.rs);
        while (this.rs.hasNext()) {
            QuerySolution qs = (QuerySolution)this.rs.next();
            this.proc.start(qs);
            Iterator iter = this.rs.getResultVars().iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                RDFNode node = qs.get(varName);
                this.proc.binding(varName, node);
            }
            this.proc.finish(qs);
        }
        this.proc.finish(this.rs);
    }

    public static void apply(ResultSet rs, ResultSetProcessor proc) {
        ResultSetApply rsa = new ResultSetApply(rs, proc);
        rsa.apply();
    }
}

