/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.junit.TestCaseARQ;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;

public class SerializerTest
extends TestCaseARQ {
    static int count = 0;
    String queryString;
    TestItem testItem;

    public SerializerTest(String testName, TestItem t) {
        super(testName);
        this.testItem = t;
    }

    public SerializerTest(String queryString) {
        this(queryString, queryString);
    }

    public SerializerTest(String testName, String queryString) {
        super(testName);
        this.setTest(testName, queryString);
    }

    private void setTest(String testName, String _queryString) {
        super.setName(testName);
        this.queryString = _queryString;
    }

    protected void runTest() throws Throwable {
        try {
            Query query2 = null;
            query2 = this.queryString == null ? this.queryFromTestItem(this.testItem) : this.queryFromString(this.queryString);
            Syntax outSyntax = Syntax.syntaxSPARQL;
            if (this.testItem != null && this.testItem.getQueryFileSyntax() != null) {
                outSyntax = this.testItem.getQueryFileSyntax();
            }
            IndentedLineBuffer buff = new IndentedLineBuffer();
            query2.serialize(buff, outSyntax);
            try {
                Query query22 = QueryFactory.create(buff.toString(), outSyntax);
                if (query22 == null) {
                    return;
                }
            }
            catch (UnsupportedOperationException ex) {
                return;
            }
            catch (QueryException ex) {
                SerializerTest.fail((String)("Parsing printed query: " + ex.getMessage()));
            }
        }
        catch (QueryException qEx) {
            throw qEx;
        }
        catch (Exception ex) {
            SerializerTest.fail((String)("Exception: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }
}

