/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.extension.library;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryFatalException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Binding1;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.QueryIterPlainWrapper;
import com.hp.hpl.jena.query.engine1.QueryIterYieldN;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.extension.ExtUtils;
import com.hp.hpl.jena.query.extension.Extension2;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class container
extends Extension2 {
    private static Log log = LogFactory.getLog((Class)container.class);
    Node typeNode = null;

    public container() {
        this.typeNode = null;
    }

    protected container(Node typeURI) {
        this.typeNode = typeURI;
    }

    protected QueryIterator exec(Expr container2, Expr member, Binding binding, ExecutionContext execCxt) {
        Graph graph = this.getExecutionContext().getActiveGraph();
        Node containerNode = null;
        if ((container2 = ExtUtils.evalToExpr(container2, binding)).isVariable()) {
            throw new QueryFatalException(Utils.className(this) + ": Arg 1 not bound (not implemented yet)");
        }
        if (container2.isConstant()) {
            containerNode = container2.getConstant().asNode();
        }
        if (containerNode == null) {
            throw new QueryFatalException(Utils.className(this) + ": Arg 1 is too hard : " + container2);
        }
        if ((member = ExtUtils.evalToExpr(member, binding)) == null) {
            throw new QueryFatalException(Utils.className(this) + ": Arg 2 is strange : " + member);
        }
        if (!member.isVariable() && !member.isConstant()) {
            throw new QueryFatalException(Utils.className(this) + ": Arg 2 is too hard : " + member);
        }
        if (member.isVariable()) {
            String varName = member.getVarName();
            Collection x = GraphUtils.containerMembers(graph, containerNode, this.typeNode);
            if (x == null) {
                return new QueryIterNullIterator(this.getExecutionContext());
            }
            ArrayList<Binding1> bindings = new ArrayList<Binding1>();
            Iterator iter = x.iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                Binding1 b = new Binding1(varName, n, binding);
                bindings.add(b);
            }
            return new QueryIterPlainWrapper(bindings.iterator(), this.getExecutionContext());
        }
        Node n = ((NodeValue)member).asNode();
        int count = GraphUtils.countContainerMember(graph, containerNode, this.typeNode, n);
        return new QueryIterYieldN(count, binding, this.getExecutionContext());
    }
}

