/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr.nodevalue;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprTypeException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.vocabulary.XSD;

public class NodeFunctions {
    private static final NodeValue xsdString = NodeValue.makeNode(XSD.xstring.asNode());

    public static NodeValue str(NodeValue nv) {
        return NodeValue.makeString(NodeFunctions.str(nv.asNode()));
    }

    public static String str(Node node) {
        if (node.isLiteral()) {
            return node.getLiteral().getLexicalForm();
        }
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isBlank()) {
            NodeValue.raise(new ExprTypeException("Blank node: " + node));
        }
        NodeValue.raise(new ExprEvalException("Not a string: " + node));
        return "[undef]";
    }

    public static NodeValue datatype(NodeValue nv) {
        return NodeValue.makeNode(NodeFunctions.datatype(nv.asNode()));
    }

    public static Node datatype(Node node) {
        boolean plainLiteral;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("datatype: Not a literal: " + node));
            return null;
        }
        String s = node.getLiteralDatatypeURI();
        boolean bl = plainLiteral = s == null || s.equals("");
        if (plainLiteral) {
            boolean simpleLiteral;
            boolean bl2 = simpleLiteral = node.getLiteralLanguage() == null || node.getLiteralLanguage().equals("");
            if (!simpleLiteral) {
                NodeValue.raise(new ExprTypeException("datatype: Literal has language tag: " + node));
            }
            return XSD.xstring.asNode();
        }
        return Node.createURI((String)s);
    }

    public static NodeValue lang(NodeValue nv) {
        return NodeValue.makeString(NodeFunctions.lang(nv.asNode()));
    }

    public static String lang(Node node) {
        String s;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("lang: Not a literal: " + node));
        }
        if ((s = node.getLiteralLanguage()) == null) {
            s = "";
        }
        return s;
    }

    public static NodeValue langMatches(NodeValue nv, NodeValue nvPattern) {
        return NodeFunctions.langMatches(nv, nvPattern.getString());
    }

    public static NodeValue langMatches(NodeValue nv, String langPattern) {
        Node node = nv.asNode();
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("langMatches: not a literal: " + node));
            return null;
        }
        String nodeLang = node.getLiteralLexicalForm();
        if (langPattern.equals("*")) {
            return NodeValue.TRUE;
        }
        String[] langElts = nodeLang.split("-");
        String[] patternElts = langPattern.split("-");
        if (patternElts.length > langElts.length) {
            return NodeValue.FALSE;
        }
        for (int i = 0; i < patternElts.length; ++i) {
            String pat = patternElts[i];
            String lang = langElts[i];
            if (pat.equalsIgnoreCase(lang)) continue;
            return NodeValue.FALSE;
        }
        return NodeValue.TRUE;
    }

    public static NodeValue isIRI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isIRI(Node node) {
        return node.isURI();
    }

    public static NodeValue isURI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isURI(Node node) {
        return NodeFunctions.isIRI(node);
    }

    public static NodeValue isBlank(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isBlank(nv.asNode()));
    }

    public static boolean isBlank(Node node) {
        return node.isBlank();
    }

    public static NodeValue isLiteral(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isLiteral(nv.asNode()));
    }

    public static boolean isLiteral(Node node) {
        return node.isLiteral();
    }
}

