/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.VariableNotBoundException;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class NodeVar
extends ExprNode {
    String name;

    public NodeVar(String _name) {
        this.name = _name;
    }

    public NodeVar(Node n) {
        if (!n.isVariable()) {
            throw new ARQInternalErrorException("Attempt to create a NodeVar from a non variable Node: " + n);
        }
        this.name = n.getName();
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        if (binding == null) {
            throw new VariableNotBoundException("Not bound: (no binding): " + this.name);
        }
        Node v = binding.get(this.name);
        if (v == null) {
            throw new VariableNotBoundException("Not bound: variable ?" + this.name);
        }
        return NodeValue.makeNode(v);
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public void format(Query query2, IndentedWriter out) {
        out.print('?');
        out.print(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NodeVar)) {
            return false;
        }
        NodeVar nvar = (NodeVar)other;
        return this.getVarName().equals(nvar.getVarName());
    }

    public boolean isVariable() {
        return true;
    }

    public String getVarName() {
        return this.name;
    }

    public NodeVar getVar() {
        return this;
    }

    public String toString() {
        return "?" + this.name;
    }
}

