/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprNode1;
import com.hp.hpl.jena.query.expr.ExprNode2;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;

public class ExprWalker {
    ExprVisitor visitor;

    public ExprWalker(ExprVisitor visitor) {
        this.visitor = visitor;
    }

    public void walk(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void walk(ExprVisitor visitor, Expr expr) {
        expr.visit(new Walker(visitor));
    }

    static class Walker
    implements ExprVisitor {
        ExprVisitor visitor;

        private Walker(ExprVisitor visitor) {
            this.visitor = visitor;
        }

        public void startVisit() {
        }

        public void visit(ExprNode1 expr) {
            expr.visit(this.visitor);
            expr.getSubExpr().visit(this);
        }

        public void visit(ExprNode2 expr) {
            expr.visit(this.visitor);
            expr.getLeft().visit(this);
            expr.getRight().visit(this);
        }

        public void visit(ExprNodeFunction func) {
            Expr expr;
            func.visit(this.visitor);
            for (int i = 1; i <= func.numArgs() && (expr = func.getArg(i)) != null; ++i) {
                expr.visit(this);
            }
        }

        public void visit(NodeValue nv) {
            nv.visit(this.visitor);
        }

        public void visit(NodeVar nv) {
            nv.visit(this.visitor);
        }

        public void finishVisit() {
        }
    }
}

