/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.Binding0;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.CompileException;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.QueryIter;
import com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import com.hp.hpl.jena.query.extension.Extension;
import com.hp.hpl.jena.query.extension.ExtensionFactory;
import com.hp.hpl.jena.query.extension.ExtensionRegistry;

public class PlanExtension
extends PlanElementBase {
    ElementExtension element;

    public static PlanElement make(Plan plan, ElementExtension el) {
        return new PlanExtension(plan, el);
    }

    private PlanExtension(Plan plan, ElementExtension el) {
        super(plan);
        this.element = el;
    }

    public ElementExtension getElement() {
        return this.element;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        String uri = this.element.getURI();
        ExtensionFactory factory = ExtensionRegistry.get().get(uri);
        if (factory == null) {
            throw new CompileException("No extension for '" + uri + "'");
        }
        Extension ext = factory.create(uri);
        ext.build(this.element.getArgs(), uri);
        if (input == null) {
            input = new QueryIterSingleton(new Binding0(), execCxt);
        }
        QueryIterator qIter = ext.exec(input, this.element.getArgs(), uri, execCxt);
        qIter = QueryIter.makeTracked(qIter, execCxt);
        return qIter;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }
}

