/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.QueryIter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterLimitOffset
extends QueryIter {
    static Log clsLog = LogFactory.getLog((Class)QueryIterLimitOffset.class);
    long count = 0L;
    long limit;
    long offset;
    QueryIterator base;

    public QueryIterLimitOffset(QueryIterator cIter, long numItems, long startPosition, ExecutionContext context) {
        super(context);
        this.limit = numItems;
        if (this.limit < 0L) {
            throw new QueryExecException("Negative LIMIT: " + this.limit);
        }
        this.offset = startPosition;
        if (this.offset < 0L) {
            throw new QueryExecException("Negative OFFSET: " + this.offset);
        }
        this.base = cIter;
        this.count = 0L;
        int i = 0;
        while ((long)i < this.offset) {
            if (!cIter.hasNext()) {
                this.close();
                break;
            }
            cIter.next();
            ++i;
        }
    }

    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (!this.base.hasNext()) {
            return false;
        }
        return this.count < this.limit;
    }

    protected Binding moveToNextBinding() {
        ++this.count;
        return this.base.nextBinding();
    }

    protected void closeIterator() {
        if (this.base != null) {
            this.base.close();
        }
        this.base = null;
    }
}

