/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.QueryIterFilter;
import com.hp.hpl.jena.query.expr.ExprException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterConstraintFilter
extends QueryIterFilter {
    private static Log log = LogFactory.getLog((Class)QueryIterConstraintFilter.class);
    Constraint constraint;

    public QueryIterConstraintFilter(QueryIterator input, Constraint constraint, ExecutionContext context) {
        super(input, context);
        this.constraint = constraint;
    }

    public boolean accept(Binding binding) {
        boolean passFilter = false;
        try {
            passFilter = this.constraint.isSatisfied(binding, this.getExecContext());
        }
        catch (ExprException ex) {
            passFilter = false;
        }
        catch (Exception ex) {
            passFilter = false;
            log.warn((Object)("General exception in " + this.constraint), (Throwable)ex);
        }
        if (!passFilter) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reject: " + this.constraint + " - " + binding));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accept: " + this.constraint + " - " + binding));
        }
        return true;
    }
}

