/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Constants;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingRoot;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.describe.DescribeHandler;
import com.hp.hpl.jena.query.describe.DescribeHandlerRegistry;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import com.hp.hpl.jena.query.engine1.QueryIter;
import com.hp.hpl.jena.query.engine1.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import com.hp.hpl.jena.query.engine1.compiler.QueryPatternCompiler;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.DatasetUtils;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngine
implements QueryExecution {
    static Log log = LogFactory.getLog((Class)QueryEngine.class);
    Query query;
    static int queryCount = 0;
    boolean queryInitialised = false;
    int idQueryExecution;
    QueryIterator resultsIter;
    Context parameters;
    ExecutionContext context = null;
    Plan plan;
    QuerySolution startBinding = null;
    FileManager fileManager = null;
    Dataset dataset = null;

    public QueryEngine(Query q) {
        this(q, null);
    }

    public QueryEngine(Query q, Context parameters) {
        if (parameters == null) {
            parameters = new Context(EngineConfig.getContext());
        }
        this.query = q;
        this.idQueryExecution = ++queryCount;
        this.parameters = parameters;
    }

    public Query getQuery() {
        return this.query;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        this.query.setResultVars();
        DatasetGraph dsg = null;
        if (this.getDataset() == null) {
            if (!(this.query.getGraphURIs() != null && this.query.getGraphURIs().size() != 0 || this.query.getNamedGraphURIs() != null && this.query.getNamedGraphURIs().size() != 0)) {
                throw new QueryExecException("No model for query");
            }
            String baseURI = this.query.getBaseURI();
            if (baseURI == null) {
                baseURI = RelURI.chooseBaseURI();
            }
            log.debug((Object)("init: baseURI for query is: " + baseURI));
            dsg = DatasetUtils.createDatasetGraph(this.query.getGraphURIs(), this.query.getNamedGraphURIs(), this.fileManager, baseURI);
        } else {
            if (this.getDataset().getDefaultModel() == null) {
                log.warn((Object)"Default model is null in the dataset");
            }
            log.debug((Object)"External data source for query");
            dsg = new DataSourceGraphImpl(this.getDataset());
        }
        if (this.query.getQueryBlock() != null) {
            this.query.getQueryBlock().setDataset(dsg);
        } else {
            this.query.setQueryBlock(new ElementBlock(dsg, null));
        }
        this.context = new ExecutionContext(this.parameters, this.getQuery(), dsg.getDefaultGraph(), dsg);
        if (this.plan == null) {
            this.plan = this.buildPlan();
        }
        this.queryInitialised = true;
    }

    public void setInitialBinding(QuerySolution rb) {
        this.startBinding = rb;
    }

    public void setFileManager(FileManager fm) {
        this.fileManager = fm;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.buildPlan();
        }
        return this.plan;
    }

    public Context getContext() {
        return this.parameters;
    }

    public Model execConstruct() {
        this.init();
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model resultModel = GraphUtils.makeJenaDefaultModel();
        this.insertPrefixesInto(resultModel);
        ResultSet qRes = this.execInternal();
        HashSet set = new HashSet();
        Template template = this.query.getConstructTemplate();
        while (qRes.hasNext()) {
            HashMap bNodeMap = new HashMap();
            QuerySolution qs = qRes.nextSolution();
            ResultBinding rb = (ResultBinding)qs;
            template.subst(set, bNodeMap, rb.getBinding());
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Statement stmt = QueryEngineUtils.tripleToStatement(resultModel, t);
            if (stmt == null) continue;
            resultModel.add(stmt);
        }
        this.close();
        return resultModel;
    }

    public Model execDescribe() {
        DescribeHandler dh;
        this.init();
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model results = GraphUtils.makeJenaDefaultModel();
        this.insertPrefixesInto(results);
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        if (this.query.getQueryBlock().getPatternElement() != null) {
            ResultSet qRes = this.execInternal();
            while (qRes.hasNext()) {
                QuerySolution rb = qRes.nextSolution();
                Iterator iter = this.query.getResultVars().iterator();
                while (iter.hasNext()) {
                    String varName = (String)iter.next();
                    RDFNode n = rb.get(varName);
                    set.add(n);
                }
            }
        }
        if (this.query.getResultURIs() != null) {
            Iterator iter = this.query.getResultURIs().iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                RDFNode rNode = NodeUtils.convertGraphNodeToRDFNode(n, this.dataset.getDefaultModel());
                set.add(rNode);
            }
        }
        DescribeHandlerRegistry dhReg = DescribeHandlerRegistry.get();
        Iterator handlers = dhReg.handlers();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.start(results, this.context);
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            RDFNode n = (RDFNode)iter.next();
            if (!(n instanceof Resource)) continue;
            Iterator handlers2 = dhReg.handlers();
            while (handlers2.hasNext()) {
                DescribeHandler dh2 = (DescribeHandler)handlers2.next();
                dh2.describe((Resource)n);
            }
        }
        handlers = dhReg.handlers();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.finish();
        }
        this.close();
        return results;
    }

    public ResultSet execSelect() {
        this.init();
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        return this.execInternal();
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        ResultSet results = this.execInternal();
        boolean r = results.hasNext();
        this.close();
        return r;
    }

    private ResultSet execInternal() {
        this.resultsIter = this.planToIterator();
        Object model = null;
        if (this.dataset != null) {
            model = this.dataset.getDefaultModel();
        }
        if (model == null) {
            Graph g = this.query.getQueryBlock().getDataset().getDefaultGraph();
            model = g != null ? ModelFactory.createModelForGraph((Graph)g) : null;
        }
        ResultSetStream rStream = new ResultSetStream(this.query.getResultVars(), (Model)model, this.resultsIter);
        if (this.query.hasOrderBy()) {
            rStream.setOrdered(true);
        }
        if (this.query.isDistinct()) {
            rStream.setDistinct(true);
        }
        return rStream;
    }

    protected PlanElement makePlanForQueryPattern(Plan plan) {
        return QueryPatternCompiler.makePlan(plan, this.query.getQueryBlock());
    }

    protected PlanElement queryPlanHook(Plan plan, PlanElement planElt) {
        return planElt;
    }

    private QueryIterator planToIterator() {
        QueryIterator qIter = null;
        try {
            this.init();
            PlanElement pElt = this.getPlan().getRoot();
            Binding rootBinding = this.makeRootBinding();
            if (this.startBinding != null) {
                Iterator iter = this.startBinding.varNames();
                while (iter.hasNext()) {
                    String n = (String)iter.next();
                    RDFNode x = this.startBinding.get(n);
                    rootBinding.add(n, x.asNode());
                }
            }
            QueryIterSingleton initialIter = new QueryIterSingleton(rootBinding, this.context);
            DataSourceGraphImpl datasetGraph = new DataSourceGraphImpl(this.dataset);
            qIter = pElt.build(initialIter, this.context);
            ElementBlock qBlock = this.query.getQueryBlock();
            if (qBlock == null) {
                return new QueryIterNullIterator(this.context);
            }
            qBlock.setDataset(datasetGraph);
            return qIter;
        }
        catch (RuntimeException ex) {
            if (qIter != null) {
                qIter.close();
            }
            throw ex;
        }
    }

    private Binding makeRootBinding() {
        BindingRoot rootBinding = Binding.createRootBinding();
        GregorianCalendar cal = new GregorianCalendar();
        String lex = Utils.calendarToXSDDateTimeString(cal);
        Node n = Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdateTime);
        rootBinding.add(Constants.varCurrentTime, n);
        return rootBinding;
    }

    private Plan buildPlan() {
        if (this.plan != null) {
            return this.plan;
        }
        this.plan = new Plan(this.parameters);
        PlanElement planElt = this.makePlanForQueryPattern(this.plan);
        planElt = this.queryPlanHook(this.plan, planElt);
        this.plan.setRoot(planElt);
        if (this.query.hasOrderBy()) {
            planElt = PlanOrderBy.make(this.plan, planElt, this.query.getOrderBy());
        }
        if (!this.query.isQueryResultStar()) {
            if (this.query.getResultVars().size() == 0 && this.query.isSelectType()) {
                log.warn((Object)"No project variables");
            }
            planElt = PlanProject.make(this.plan, planElt, this.query.getResultVars());
        }
        if (this.query.isDistinct()) {
            planElt = PlanDistinct.make(this.plan, planElt, this.query.getResultVars());
        }
        if (this.query.hasLimit() || this.query.hasOffset()) {
            planElt = PlanLimitOffset.make(this.plan, planElt, this.query.getLimit(), this.query.getOffset());
        }
        this.plan.setRoot(planElt);
        return this.plan;
    }

    public void abort() {
        this.close(true);
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean forceClose) {
        if (!this.queryInitialised) {
            log.warn((Object)"Closing a query that has not been run");
            return;
        }
        if (forceClose) {
            if (this.resultsIter != null) {
                this.resultsIter.close();
            }
            this.resultsIter = null;
        }
        Iterator iter = this.context.listOpenIterators();
        while (iter.hasNext()) {
            QueryIterator qIterOpen = (QueryIterator)iter.next();
            if (qIterOpen instanceof QueryIter) {
                QueryIter qIterBase = (QueryIter)qIterOpen;
                log.warn((Object)("Open iterator: " + qIterBase.getCounter() + " " + qIterOpen));
                continue;
            }
            log.warn((Object)("Open iterator: " + qIterOpen));
        }
        if (this.resultsIter != null) {
            this.resultsIter.close();
        }
        this.resultsIter = null;
    }

    private void insertPrefixesInto(Model model) {
        try {
            PrefixMapping m = this.query.getQueryBlock().getDataset().getDefaultGraph().getPrefixMapping();
            model.setNsPrefixes(m);
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            log.warn((Object)("Exception in insertPrefixes: " + ex.getMessage()));
        }
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }
}

