/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasicPattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.compiler.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import java.util.Iterator;

public class PlanWalker {
    PlanVisitor proc;

    public PlanWalker(PlanVisitor v) {
        this.proc = v;
    }

    public static void walk(PlanVisitor v, PlanElement el) {
        el.visit(new Walker(v));
    }

    public void walk(PlanElement el) {
        el.visit(new Walker(this.proc));
    }

    private static class Walker
    implements PlanVisitor {
        PlanVisitor proc;

        Walker(PlanVisitor v) {
            this.proc = v;
        }

        public void visit(PlanBasicPattern planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanTriplePattern planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanGroup planElt) {
            Iterator iter = planElt.getPlanElements().iterator();
            while (iter.hasNext()) {
                PlanElement e2 = (PlanElement)iter.next();
                e2.visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanUnion planElt) {
            Iterator iter = planElt.getPlanElements().iterator();
            while (iter.hasNext()) {
                PlanElement e2 = (PlanElement)iter.next();
                e2.visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanOptional planElt) {
            if (planElt.getSub() != null) {
                planElt.getSub().visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanUnsaid planElt) {
            if (planElt.getSub() != null) {
                planElt.getSub().visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanFilter planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanNamedGraph planElt) {
            if (planElt.getSub() != null) {
                planElt.getSub().visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanOuterJoin planElt) {
            Iterator iter = planElt.getPlanElements().iterator();
            while (iter.hasNext()) {
                PlanElement e2 = (PlanElement)iter.next();
                e2.visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanExtension planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanBlock planElt) {
            if (planElt.getSub() != null) {
                planElt.getSub().visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanProject planElt) {
            planElt.getSub().visit(this);
            this.proc.visit(planElt);
        }

        public void visit(PlanDistinct planElt) {
            planElt.getSub().visit(this);
            this.proc.visit(planElt);
        }

        public void visit(PlanOrderBy planElt) {
            planElt.getSub().visit(this);
            this.proc.visit(planElt);
        }

        public void visit(PlanLimitOffset planElt) {
            planElt.getSub().visit(this);
            this.proc.visit(planElt);
        }
    }
}

