/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.ElementVisitorBase;
import com.hp.hpl.jena.query.expr.Expr;
import java.util.Iterator;
import java.util.Set;

public class VarsMentionedVisitor
extends ElementVisitorBase
implements ElementVisitor {
    Set acc;

    public VarsMentionedVisitor(Set s) {
        this.acc = s;
    }

    public void visit(ElementTriplePattern el) {
        Triple t = el.getTriple();
        VarsMentionedVisitor.addVarsFromTriple(this.acc, t);
    }

    public void visit(ElementFilter el) {
        el.getConstraint().varsMentioned(this.acc);
    }

    public void visit(ElementNamedGraph el) {
        VarsMentionedVisitor.addVar(this.acc, el.getGraphNameNode());
    }

    public void visit(ElementExtension el) {
        Iterator iter = el.getArgs().iterator();
        while (iter.hasNext()) {
            Expr e2 = (Expr)iter.next();
            e2.varsMentioned(this.acc);
        }
    }

    private static void addVarsFromTriple(Set acc, Triple t) {
        VarsMentionedVisitor.addVar(acc, t.getSubject());
        VarsMentionedVisitor.addVar(acc, t.getPredicate());
        VarsMentionedVisitor.addVar(acc, t.getObject());
    }

    private static void addVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n.getName());
        }
    }
}

