/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import java.util.ListIterator;

public abstract class RecursiveVisitor
implements ElementVisitor {
    public void startElement(ElementBlock el) {
    }

    public void endElement(ElementBlock el) {
    }

    public void startElement(ElementFilter el) {
    }

    public void endElement(ElementFilter el) {
    }

    public void startElement(ElementUnion el) {
    }

    public void endElement(ElementUnion el) {
    }

    public void startSubElement(ElementUnion el, Element subElt) {
    }

    public void endSubElement(ElementUnion el, Element subElt) {
    }

    public void startElement(ElementGroup el) {
    }

    public void endElement(ElementGroup el) {
    }

    public void startSubElement(ElementGroup el, Element subElt) {
    }

    public void endSubElement(ElementGroup el, Element subElt) {
    }

    public void startElement(ElementOptional el) {
    }

    public void endElement(ElementOptional el) {
    }

    public void startElement(ElementNamedGraph el) {
    }

    public void endElement(ElementNamedGraph el) {
    }

    public void startElement(ElementUnsaid el) {
    }

    public void endElement(ElementUnsaid el) {
    }

    public void visit(ElementBlock el) {
        this.startElement(el);
        el.getPatternElement().visit(this);
        this.endElement(el);
    }

    public void visit(ElementFilter el) {
        this.startElement(el);
        this.endElement(el);
    }

    public void visit(ElementUnion el) {
        this.startElement(el);
        ListIterator iter = el.elements.listIterator();
        while (iter.hasNext()) {
            Element subElement = (Element)iter.next();
            this.startSubElement(el, subElement);
            subElement.visit(this);
            this.endSubElement(el, subElement);
        }
        this.endElement(el);
    }

    public void visit(ElementGroup el) {
        this.startElement(el);
        ListIterator iter = el.elements.listIterator();
        while (iter.hasNext()) {
            Element subElement = (Element)iter.next();
            this.startSubElement(el, subElement);
            subElement.visit(this);
            this.endSubElement(el, subElement);
        }
        this.endElement(el);
    }

    public void visit(ElementOptional el) {
        this.startElement(el);
        el.getElement().visit(this);
        this.endElement(el);
    }

    public void visit(ElementNamedGraph el) {
        this.startElement(el);
        el.getElement().visit(this);
        this.endElement(el);
    }

    public void visit(ElementUnsaid el) {
        this.startElement(el);
        el.getElement().visit(this);
        this.endElement(el);
    }
}

