/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.E_Function;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprBuiltIn;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.Utils;

public class SortCondition {
    public Expr expression = null;
    public int direction = 0;

    public SortCondition(String varName, int dir) {
        this(new NodeVar(varName), dir);
    }

    public SortCondition(Node var, int dir) {
        this(var.getName(), dir);
    }

    public SortCondition(Expr expr, int dir) {
        this.expression = expr;
        this.direction = dir;
    }

    public void format(ExprVisitor fmt, IndentedWriter writer) {
        boolean explicitDirection = false;
        boolean doDirection = this.direction != Query.ASCENDING ? true : explicitDirection;
        boolean needParens = false;
        if (doDirection && (this.expression.isVariable() || this.expression instanceof E_Function)) {
            needParens = true;
        }
        if (this.expression instanceof ExprBuiltIn) {
            needParens = true;
        }
        if (doDirection && this.direction == Query.ASCENDING) {
            writer.print("ASC");
            needParens = true;
        }
        if (doDirection && this.direction == Query.DESCENDING) {
            writer.print("DESC");
            needParens = true;
        }
        if (needParens) {
            writer.print("(");
        }
        this.expression.visit(fmt);
        if (needParens) {
            writer.print(")");
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public Expr getExpression() {
        return this.expression;
    }

    public int hashCode() {
        int x = this.getDirection();
        if (this.getExpression() != null) {
            x ^= this.getExpression().hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SortCondition)) {
            return false;
        }
        SortCondition sc = (SortCondition)other;
        if (sc.getDirection() != this.getDirection()) {
            return false;
        }
        return Utils.eq(this.getExpression(), sc.getExpression());
    }
}

