/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.engine.QueryEngineFactory;
import com.hp.hpl.jena.query.engine.QueryEngineRegistry;
import com.hp.hpl.jena.query.engineHTTP.QueryEngineHTTP;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class QueryExecutionFactory {
    private QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query2) {
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.make(query2);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset);
    }

    public static QueryExecution create(Query query2, FileManager fm) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (fm != null) {
            qe.setFileManager(fm);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), fm);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), fm);
    }

    public static QueryExecution create(Query query2, Model model) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.make(query2, new DataSourceImpl(model));
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    public static QueryExecution create(Query query2, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), initialBinding);
    }

    public static QueryExecution create(Query query2, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(query2, (Dataset)new DataSourceImpl(model), initialBinding);
    }

    public static QueryExecution create(String queryStr, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), model, initialBinding);
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2, dataset);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, initialBinding);
    }

    public static QueryExecution sparqlService(String service, Query query2) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.makeServiceRequest(service, query2);
    }

    public static QueryExecution create(String service, Query query2) {
        return QueryExecutionFactory.sparqlService(service, query2);
    }

    public static QueryExecution sparqlService(String service, Query query2, String defaultGraph) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        QueryEngineHTTP qe = QueryExecutionFactory.makeServiceRequest(service, query2);
        qe.addDefaultGraph(defaultGraph);
        return qe;
    }

    public static QueryExecution create(String service, Query query2, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(service, query2, defaultGraph);
    }

    public static QueryExecution sparqlService(String service, Query query2, List defaultGraphURIs, List namedGraphURIs) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        QueryEngineHTTP qe = QueryExecutionFactory.makeServiceRequest(service, query2);
        if (defaultGraphURIs != null) {
            qe.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs != null) {
            qe.setNamedGraphURIs(namedGraphURIs);
        }
        return qe;
    }

    public static QueryExecution create(String service, Query query2, List defaultGraphURIs, List namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(service, query2, defaultGraphURIs, namedGraphURIs);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    private static QueryExecution make(Query query2) {
        return QueryExecutionFactory.make(query2, null);
    }

    private static QueryExecution make(Query query2, Dataset dataset) {
        QueryEngineFactory f = QueryEngineRegistry.get().find(query2, dataset);
        if (f == null) {
            LogFactory.getLog((Class)QueryExecutionFactory.class).warn((Object)("Failed to find a QueryEngineFactory for query: " + query2));
            return null;
        }
        return f.create(query2, dataset);
    }

    private static QueryEngineHTTP makeServiceRequest(String service, Query query2) {
        return new QueryEngineHTTP(service, query2);
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkArg(Model model) {
        QueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        QueryExecutionFactory.checkNotNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query2) {
        QueryExecutionFactory.checkNotNull(query2, "Query is null");
    }
}

