/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline.test;

import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestCmdLine
extends TestCase {
    public void test_Simple1() {
        String[] stringArray = new String[]{""};
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        cmdLineArgs.process();
    }

    public void test_Flag1() {
        String[] stringArray = new String[]{""};
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "-a");
        cmdLineArgs.add(argDecl);
        cmdLineArgs.process();
        TestCmdLine.assertTrue((String)"-a argument found", (!cmdLineArgs.contains(argDecl) ? 1 : 0) != 0);
    }

    public void test_Flag2() {
        String[] stringArray = new String[]{"-a"};
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "-a");
        cmdLineArgs.add(argDecl);
        cmdLineArgs.process();
        TestCmdLine.assertTrue((String)"No -a argument found", (boolean)cmdLineArgs.contains(argDecl));
    }

    public void test_Flag3() {
        String[] stringArray = new String[]{"-a", "filename"};
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "-a");
        cmdLineArgs.add(argDecl);
        cmdLineArgs.process();
        TestCmdLine.assertTrue((String)"No -a argument found", (boolean)cmdLineArgs.contains(argDecl));
    }

    public void test_Arg1() {
        String[] stringArray = new String[]{""};
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(true, "-arg");
        cmdLineArgs.add(argDecl);
        cmdLineArgs.process();
        TestCmdLine.assertTrue((String)"-arg argument found", (!cmdLineArgs.contains(argDecl) ? 1 : 0) != 0);
    }

    public void test_Arg2() {
        String[] stringArray = new String[]{"-arg=ARG", "filename"};
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(true, "-arg");
        cmdLineArgs.add(argDecl);
        cmdLineArgs.process();
        TestCmdLine.assertTrue((String)"No -arg= argument found", (boolean)cmdLineArgs.contains(argDecl));
        TestCmdLine.assertEquals((String)"", (String)cmdLineArgs.getValue(argDecl), (String)"ARG");
        TestCmdLine.assertEquals((String)"", (String)cmdLineArgs.getArg("arg").getValue(), (String)"ARG");
    }

    public void test_nArg1() {
        String[] stringArray = new String[]{"-arg=V1", "--arg=V2", "-v"};
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(true, "-arg");
        cmdLineArgs.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "-v");
        cmdLineArgs.add(argDecl2);
        cmdLineArgs.process();
        TestCmdLine.assertTrue((String)"No -arg= argument found", (boolean)cmdLineArgs.contains(argDecl));
        Iterator iterator = cmdLineArgs.getValues("arg").iterator();
        TestCmdLine.assertEquals((String)"Argument 1", iterator.next(), (Object)"V1");
        TestCmdLine.assertEquals((String)"Argument 2", iterator.next(), (Object)"V2");
    }
}

