/*
 * Decompiled with CFR 0.152.
 */
package arq.cmd;

import arq.cmd.ResultsFormat;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.PlainFormat;
import com.hp.hpl.jena.query.resultset.ResultSetApply;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.OutputStream;

public class QExec {
    Query query;
    QueryExecution queryExecution;
    ResultsFormat outputFormat;

    public QExec(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        this.query = query2;
        this.queryExecution = queryExecution;
        this.outputFormat = resultsFormat;
    }

    public void executeQuery() {
        QExec.doQuery(this.query, this.queryExecution, this.outputFormat);
    }

    public static void doQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        if (query2.isSelectType()) {
            QExec.doSelectQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isDescribeType()) {
            QExec.doDescribeQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isConstructType()) {
            QExec.doConstructQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isAskType()) {
            QExec.doAskQuery(query2, queryExecution, resultsFormat);
        }
        queryExecution.close();
    }

    private static void doSelectQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Object object;
        ResultSet resultSet = queryExecution.execSelect();
        resultSet = ResultSetFactory.makeRewindable(resultSet);
        boolean bl = false;
        if (resultsFormat.equals(ResultsFormat.FMT_NONE) || resultsFormat.equals(ResultsFormat.FMT_COUNT)) {
            int n = ResultSetFormatter.consume(resultSet);
            if (resultsFormat.equals(ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + n);
            }
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_RDF) || resultsFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            Model model = ResultSetFormatter.toModel(resultSet);
            model.setNsPrefixes(query2.getPrefixMapping());
            object = model.getWriter("TURTLE");
            model.setNsPrefix("rs", ResultSetVocab.getURI());
            object.write(model, (OutputStream)System.out, null);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, resultSet);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, resultSet);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, resultSet, query2);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, resultSet, query2.getPrefixMapping());
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TUPLES)) {
            PlainFormat plainFormat = new PlainFormat((OutputStream)System.out, query2.getPrefixMapping());
            object = new ResultSetApply(resultSet, plainFormat);
            ((ResultSetApply)object).apply();
            bl = true;
        }
        if (!bl) {
            System.err.println("Unknown format request: " + resultsFormat);
        }
        System.out.flush();
    }

    private static void doDescribeQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Model model = queryExecution.execDescribe();
        QExec.writeModel(query2, model, resultsFormat);
    }

    private static void doConstructQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Model model = queryExecution.execConstruct();
        QExec.writeModel(query2, model, resultsFormat);
    }

    private static void writeModel(Query query2, Model model, ResultsFormat resultsFormat) {
        if (resultsFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            String string = "";
            if (query2.isDescribeType()) {
                string = "DESCRIBE";
            }
            if (query2.isConstructType()) {
                string = "CONSTRUCT";
            }
            System.out.println("# ======== " + string + " results ");
            model.write((OutputStream)System.out, "N3", null);
            System.out.println("# ======== ");
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_XML)) {
            model.write((OutputStream)System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            model.write((OutputStream)System.out, "N3", null);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_NT)) {
            model.write((OutputStream)System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + resultsFormat.getSymbol());
    }

    private static void doAskQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        boolean bl = queryExecution.execAsk();
        if (resultsFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, bl);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_N3) || resultsFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            ResultSetFormatter.outputAsRDF((OutputStream)System.out, "TURTLE", bl);
            System.out.flush();
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, bl);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (bl ? "Yes" : "No"));
            return;
        }
        System.err.println("Unknown format: " + resultsFormat.getSymbol());
    }
}

