/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.test.TestXMLFeatures;
import com.hp.hpl.jena.xmloutput.test.testWriterInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class testWriterAndReader
extends ModelTestBase
implements RDFErrorHandler {
    private static boolean showProgress = false;
    private static int firstTest = 4;
    private static int lastTest = 9;
    private static int repetitionsJ = 6;
    protected static Log logger = LogFactory.getLog((Class)testWriterAndReader.class);
    String lang;
    String test;
    int fileNumber;
    int options = 0;
    static Resource[] blockRules = new Resource[]{RDFSyntax.parseTypeLiteralPropertyElt, RDFSyntax.parseTypeCollectionPropertyElt, RDFSyntax.propertyAttr, RDFSyntax.sectionReification, RDFSyntax.sectionListExpand, RDFSyntax.parseTypeResourcePropertyElt, DAML_OIL.collection};
    static final String[] baseUris = new String[]{"http://foo.com/Hello", "http://foo.com/Hello", "http://daml.umbc.edu/ontologies/calendar-ont", "http://www.daml.org/2001/03/daml+oil-ex"};
    ByteArrayOutputStream tmpOut;
    static boolean linuxFileDeleteErrorFlag = false;

    testWriterAndReader(String name, String lang, int fName) {
        super(name);
        this.lang = lang;
        this.fileNumber = fName;
    }

    testWriterAndReader(String name, String lang, int fName, int options) {
        super(name);
        this.lang = lang;
        this.fileNumber = fName;
        this.options = options;
    }

    public String toString() {
        return this.getName() + " " + this.lang + " t" + this.fileNumber + "000.rdf" + (this.options != 0 ? "[" + this.options + "]" : "");
    }

    static Test suite(String lang) {
        return testWriterAndReader.suite(lang, false);
    }

    public static Test suite() {
        return testWriterAndReader.suite("special");
    }

    private static boolean nBits(int i, int[] ok) {
        int cnt = 0;
        while (i > 0) {
            if ((i & 1) == 1) {
                ++cnt;
            }
            i >>= 1;
        }
        for (int j = 0; j < ok.length; ++j) {
            if (cnt != ok[j]) continue;
            return true;
        }
        return false;
    }

    static Test suite(String lang, boolean lots) {
        TestSuite langsuite = new TestSuite();
        langsuite.setName(lang);
        if (lang.equals("special")) {
            langsuite.addTest((Test)new TestXMLFeatures("testNoReification", "RDF/XML-ABBREV"));
            return langsuite;
        }
        langsuite.addTest((Test)new testWriterInterface("testWriting", lang));
        langsuite.addTest((Test)new testWriterInterface("testLineSeparator", lang));
        for (int k = firstTest; k <= lastTest; ++k) {
            if (lang.indexOf("XML") <= 0) continue;
            langsuite.addTest((Test)new testWriterAndReader("testLongId", lang, k));
            for (int j = 1; j < (lang.equals("RDF/XML-ABBREV") ? 1 << blockRules.length : 2); ++j) {
                if (!lots && !testWriterAndReader.nBits(j, new int[]{1, 6, 7})) continue;
                langsuite.addTest((Test)new testWriterAndReader("testOptions " + k + " " + j, lang, k, j){

                    public void runTest() throws IOException {
                        this.testOptions();
                    }
                });
            }
        }
        if (lang.indexOf("XML") > 0) {
            langsuite.addTest((Test)new TestXMLFeatures("testBadURIAsProperty1", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testBadURIAsProperty2", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testBadProperty1", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testLiAsProperty1", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDescriptionAsProperty", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testXMLBase", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testRelativeAPI", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testRelative", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testBug696057", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testPropertyURI", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUseNamespace", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUseDefaultNamespace", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUseUnusedNamespace", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testBadPrefixNamespace", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testRDFNamespace", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDuplicatePrefixSysPropAndExplicit", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testRDFDefaultNamespace", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDuplicateNamespace", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDuplicatePrefix", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUseNamespaceSysProp", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDefaultNamespaceSysProp", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDuplicateNamespaceSysProp", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDuplicatePrefixSysProp", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUTF8DeclAbsent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUTF16DeclAbsent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUTF8DeclPresent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testUTF16DeclPresent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testISO8859_1_DeclAbsent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testISO8859_1_DeclPresent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testStringDeclAbsent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testStringDeclPresent", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testTab", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNoLiteral", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNoTab", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testDoubleQuote", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testSingleQuote", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNullBaseWithAbbrev", lang));
        }
        if (lang.equals("RDF/XML-ABBREV")) {
            langsuite.addTest((Test)new TestXMLFeatures("testNoPropAttr", "RDF/XML-ABBREV"));
            langsuite.addTest((Test)new TestXMLFeatures("testNoDamlCollection", "RDF/XML-ABBREV"));
            langsuite.addTest((Test)new TestXMLFeatures("testNoRdfCollection", "RDF/XML-ABBREV"));
            langsuite.addTest((Test)new TestXMLFeatures("testNoLi", "RDF/XML-ABBREV"));
            langsuite.addTest((Test)new TestXMLFeatures("testNoID", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNoID2", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNoResource", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNoReification", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNoPropAttrs", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testNoCookUp", lang));
            langsuite.addTest((Test)new TestXMLFeatures("testPropAttrs", lang));
        }
        return langsuite;
    }

    public void testRandom() throws IOException {
        this.doTest(new String[0], new Object[0]);
    }

    public void testLongId() throws IOException {
        this.doTest(new String[]{"longId"}, new Object[]{new Boolean(true)});
    }

    public void testOptions() throws IOException {
        Vector<Resource> v = new Vector<Resource>();
        for (int i = 0; i < blockRules.length; ++i) {
            if ((this.options & 1 << i) == 0) continue;
            v.add(blockRules[i]);
        }
        Object[] blocked = new Resource[v.size()];
        v.copyInto(blocked);
        this.doTest(new String[]{"blockRules"}, new Object[]{blocked});
    }

    public void doTest(String[] propNames, Object[] propVals) throws IOException {
        this.test(this.lang, 35, 1, propNames, propVals);
    }

    public void test(String rwLang, int seed, int jjjMax, String[] wopName, Object[] wopVal) throws IOException {
        Model m1 = testWriterAndReader.createMemModel();
        Model m2 = testWriterAndReader.createMemModel();
        this.test = "testWriterAndReader lang=" + rwLang + " seed=" + seed;
        String filebase = "testing/regression/testWriterAndReader/";
        if (showProgress) {
            System.out.println("Beginning " + this.test);
        }
        Random random = new Random(seed);
        RDFReader rdfRdr = m1.getReader(rwLang);
        RDFWriter rdfWtr = m1.getWriter(rwLang);
        if (wopName != null) {
            for (int i = 0; i < wopName.length; ++i) {
                rdfWtr.setProperty(wopName[i], wopVal[i]);
            }
        }
        rdfRdr.setErrorHandler((RDFErrorHandler)this);
        rdfWtr.setErrorHandler((RDFErrorHandler)this);
        for (int jjj = 0; jjj < jjjMax; ++jjj) {
            String fileName = "t" + this.fileNumber * 1000 + ".rdf";
            m1 = testWriterAndReader.createMemModel();
            String baseUriRead = this.fileNumber < baseUris.length ? baseUris[this.fileNumber] : "http://foo.com/Hello";
            FileInputStream rdr = new FileInputStream(filebase + fileName);
            m1.read((InputStream)rdr, baseUriRead);
            ((InputStream)rdr).close();
            for (int j = 0; j < repetitionsJ; ++j) {
                String baseUriWrite = j % 2 == 0 ? baseUriRead : "http://bar.com/irrelevant";
                int cn = (int)m1.size();
                if (j % 2 == 0 && j > 0) {
                    this.prune(m1, random, 1 + cn / 10);
                }
                if (j % 2 == 0 && j > 0) {
                    this.expand(m1, random, 1 + cn / 10);
                }
                this.tmpOut = new ByteArrayOutputStream();
                rdfWtr.write(m1, (OutputStream)this.tmpOut, baseUriWrite);
                this.tmpOut.flush();
                this.tmpOut.close();
                m2 = testWriterAndReader.createMemModel();
                ByteArrayInputStream in = new ByteArrayInputStream(this.tmpOut.toByteArray());
                rdfRdr.read(m2, (InputStream)in, baseUriWrite);
                ((InputStream)in).close();
                Model s1 = m1;
                Model s2 = m2;
                testWriterAndReader.assertTrue((String)"Comparison of file written out, and file read in.", (boolean)s1.isIsomorphicWith(s2));
                this.tmpOut.reset();
                this.tmpOut = null;
            }
            if (!showProgress) continue;
            System.out.print("+");
            System.out.flush();
        }
        if (showProgress) {
            System.out.println("End of " + this.test);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune(Model m, Random random, int cnt) {
        int i;
        Statement[] die = new Statement[cnt];
        int sz = (int)m.size();
        StmtIterator ss = m.listStatements();
        try {
            for (i = 0; i < cnt; ++i) {
                die[i] = ss.nextStatement();
            }
            while (ss.hasNext()) {
                int ix = random.nextInt(sz);
                if (ix >= cnt) continue;
                die[ix] = ss.nextStatement();
            }
        }
        finally {
            ss.close();
        }
        for (i = 0; i < cnt; ++i) {
            m.remove(die[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(Model m, Random random, int cnt) {
        int i;
        Resource[] subject = new Resource[cnt];
        Property[] predicate = new Property[cnt];
        RDFNode[] object = new RDFNode[cnt];
        int sz = (int)m.size();
        StmtIterator ss = m.listStatements();
        try {
            for (i = 0; i < cnt; ++i) {
                Statement s = ss.nextStatement();
                subject[i] = s.getSubject();
                predicate[i] = s.getPredicate();
                object[i] = s.getObject();
            }
            while (ss.hasNext()) {
                Statement s = ss.nextStatement();
                Resource subj = s.getSubject();
                RDFNode obj = s.getObject();
                int ix = random.nextInt(sz);
                if (ix < cnt) {
                    subject[ix] = subj;
                }
                if ((ix = random.nextInt(sz)) < cnt) {
                    object[ix] = subj;
                }
                if ((ix = random.nextInt(sz)) < cnt) {
                    predicate[ix] = s.getPredicate();
                }
                if ((ix = random.nextInt(sz)) < cnt) {
                    object[ix] = obj;
                }
                if (!(obj instanceof Resource) || (ix = random.nextInt(sz)) >= cnt) continue;
                subject[ix] = (Resource)obj;
            }
        }
        finally {
            ss.close();
        }
        for (i = 0; i < cnt; ++i) {
            m.add(subject[i], predicate[i], object[i]);
        }
    }

    public void warning(Exception e) {
        System.out.println(new String(this.tmpOut.toString()));
        throw new JenaException((Throwable)e);
    }

    public void error(Exception e) {
        testWriterAndReader.fail((String)e.getMessage());
    }

    public void fatalError(Exception e) {
        this.error(e);
        throw new JenaException((Throwable)e);
    }
}

