/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBindingImpl;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryTestsMisc
extends TestSuite {
    static final String testSetName = "RDQL - Query - Other";
    public static String baseURI = "http://rdql/";

    public static TestSuite suite() {
        return new QueryTestsMisc(testSetName);
    }

    private QueryTestsMisc(String name) {
        super(name);
        try {
            this.addTest((Test)new TestQueryTriplesMerge());
            this.addTest((Test)new TestQueryGetTriples());
            this.addTest((Test)new TestQueryGetTriples2());
        }
        catch (Exception ex) {
            System.err.println("Problems making RDQL test");
            ex.printStackTrace(System.err);
            return;
        }
    }

    static class TestQueryGetTriples2
    extends TestQueryTriples {
        TestQueryGetTriples2() {
            super("TestQueryGetTriples2");
        }

        protected void runTest() throws Throwable {
            Model model2 = ModelFactory.createDefaultModel();
            String queryString = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(queryString);
            query.setSource(this.model);
            QueryEngine qe = new QueryEngine(query);
            QueryResults results = qe.exec();
            int i = 0;
            while (results.hasNext()) {
                ResultBindingImpl rb = (ResultBindingImpl)results.next();
                Set s = rb.getTriples();
                TestQueryGetTriples2.assertTrue((String)(this.getName() + ": getTriples2(loop " + ++i + ")"), (rb.getTriples().size() == 1 ? 1 : 0) != 0);
            }
            results.close();
        }
    }

    static class TestQueryGetTriples
    extends TestQueryTriples {
        TestQueryGetTriples() {
            super("TestQueryGetTriples");
        }

        protected void runTest() throws Throwable {
            Model model2 = ModelFactory.createDefaultModel();
            String queryString = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(queryString);
            query.setSource(this.model);
            QueryEngine qe = new QueryEngine(query);
            QueryResults results = qe.exec();
            int i = 0;
            while (results.hasNext()) {
                ResultBindingImpl rb = (ResultBindingImpl)results.next();
                TestQueryGetTriples.assertTrue((String)(this.getName() + ": getTriples(loop " + ++i + ")"), (rb.getTriples().size() == 1 ? 1 : 0) != 0);
            }
            results.close();
        }
    }

    static class TestQueryTriplesMerge
    extends TestQueryTriples {
        TestQueryTriplesMerge() {
            super("TestQueryTriplesMerge");
        }

        protected void runTest() throws Throwable {
            Model model2 = ModelFactory.createDefaultModel();
            String queryString = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(queryString);
            query.setSource(this.model);
            QueryEngine qe = new QueryEngine(query);
            QueryResults results = qe.exec();
            while (results.hasNext()) {
                ResultBindingImpl rb = (ResultBindingImpl)results.next();
                rb.mergeTriples(model2);
            }
            results.close();
            TestQueryTriplesMerge.assertTrue((String)(this.getName() + ": merged rsults not the same as target model"), (boolean)this.model.isIsomorphicWith(model2));
        }
    }

    static abstract class TestQueryTriples
    extends TestCase {
        Model model = ModelFactory.createDefaultModel();
        Resource r = this.model.createResource(baseURI + "r");

        TestQueryTriples(String testName) {
            super(testName);
            this.r.addProperty(this.model.createProperty(baseURI + "p1"), "v1");
            this.r.addProperty(this.model.createProperty(baseURI + "p2"), "v2");
        }
    }
}

