/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.ResultBindingImpl;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryTestProgrammatic
extends TestSuite {
    static final String testSetName = "RDQL - Query - Programmatic";
    public static boolean dumpModel = false;
    public static boolean verbose = false;

    public static TestSuite suite() {
        return new QueryTestProgrammatic(testSetName);
    }

    private QueryTestProgrammatic(String name) {
        super(name);
        try {
            Model model1 = QueryTestProgrammatic.makeModel1();
            Model model2 = QueryTestProgrammatic.makeModel2();
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-1", model1, "SELECT ?x, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-2", model1, "SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-3", model1, "SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-4", model2, "SELECT ?x, ?a, ?b, ?y, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-5", model2, "SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-6", model2, "SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)"));
            ResultBindingImpl rb = new ResultBindingImpl();
            rb.add("x", (RDFNode)model1.createResource("http://never/r-1"));
            rb.add("y", (RDFNode)model1.createResource("http://never/p-1"));
            this.addTest((Test)new TestQueryTemplate("RDQL-Test-Template-1", model1, null, "SELECT * WHERE (?x, ?y, ?z)", model1.size()));
            this.addTest((Test)new TestQueryTemplate("RDQL-Test-Template-2", model1, rb, "SELECT * WHERE (?x, ?y, ?z)", 1L));
        }
        catch (Exception ex) {
            System.err.println("Problems making RDQL test");
            ex.printStackTrace(System.err);
            return;
        }
    }

    public static Model makeModel1() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                model.add(model.createResource("http://never/r-" + i), model.createProperty("http://never/p-" + j), (long)(i + j));
            }
        }
        Bag bag = model.createBag("http://never/bag");
        bag.add("11");
        bag.add("22");
        model.add(model.createResource("http://never/path"), model.createProperty("http://never/path"), (RDFNode)model.createResource("http://never/r-0"));
        return model;
    }

    public static Model makeModel2() throws Exception {
        Model model = QueryTestProgrammatic.makeModel1();
        Resource anon1 = model.createResource();
        Resource anon2 = model.createResource();
        model.add(anon1, model.createProperty("http://never/p-anon-1"), "p-anon-1");
        model.add(anon2, model.createProperty("http://never/p-anon-2"), "p-anon-2");
        model.add(anon1, model.createProperty("http://never/p-anon-1-2"), (RDFNode)anon2);
        return model;
    }

    static class TestQueryTemplate
    extends TestCase {
        Model model;
        String queryString;
        ResultBindingImpl binding;
        long numResults;

        TestQueryTemplate(String testName, Model m, ResultBindingImpl b, String q, long num) {
            super(testName);
            this.model = m;
            this.queryString = q;
            this.binding = b;
            this.numResults = num;
        }

        protected void runTest() throws Throwable {
            if (verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(this.queryString);
            }
            Query query = new Query(this.queryString);
            query.setSource(this.model);
            QueryEngine _qe = new QueryEngine(query);
            QueryResults results = _qe.exec(this.binding);
            QueryEngine qe = _qe;
            long count = 0L;
            while (results.hasNext()) {
                ResultBinding rb = (ResultBinding)results.next();
                if (rb == null) {
                    throw new Exception("TestQueryTemplate: found null result binding");
                }
                Iterator iter = query.getResultVars().iterator();
                while (iter.hasNext()) {
                    Object original;
                    String varName = (String)iter.next();
                    Object obj = rb.get(varName);
                    TestQueryTemplate.assertNotNull((String)("Variable: " + varName), (Object)obj);
                    if (this.binding == null || (original = this.binding.get(varName)) == null) continue;
                    TestQueryTemplate.assertTrue((String)("Variable: " + varName + " = " + original + " / " + obj), (boolean)original.equals(obj));
                }
                ++count;
            }
            results.close();
            if (count != this.numResults) {
                throw new Exception("TestQueryTemplate: mismatch in counts.  Expected " + this.numResults + ".  Got " + count + "  Query: " + this.queryString);
            }
        }
    }

    static class TestProgrammatic
    extends TestCase {
        Model model;
        String queryString;

        TestProgrammatic(String testName, Model m, String q) {
            super(testName);
            this.model = m;
            this.queryString = q;
        }

        protected void runTest() throws Throwable {
            if (verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(this.queryString);
            }
            Query query = new Query(this.queryString);
            query.setSource(this.model);
            QueryEngine qe = new QueryEngine(query);
            QueryResults results = qe.exec();
            while (results.hasNext()) {
                ResultBindingImpl rb = (ResultBindingImpl)results.next();
                Iterator iter = rb.getTriples().iterator();
                while (iter.hasNext()) {
                    Statement s = (Statement)iter.next();
                    TestProgrammatic.assertTrue((String)"Statement not in model", (boolean)this.model.contains(s));
                }
            }
            results.close();
        }
    }
}

