/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.FrontsTriple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestStatements
extends ModelTestBase {
    public TestStatements(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestStatements.class);
    }

    public void testStuff() {
        Model red = ModelFactory.createDefaultModel();
        Model blue = ModelFactory.createDefaultModel();
        Resource r = red.createResource();
        Property p = red.createProperty("");
        Statement s = blue.createStatement(r, p, (RDFNode)r);
        TestStatements.assertEquals((String)"subject preserved", (Object)r, (Object)s.getSubject());
        TestStatements.assertEquals((String)"object preserved", (Object)r, (Object)s.getObject());
    }

    public void testOtherStuff() {
        Model A = ModelFactory.createDefaultModel();
        Model B = ModelFactory.createDefaultModel();
        Resource S = A.createResource("jena:S");
        Resource R = A.createResource("jena:R");
        Property P = A.createProperty("jena:P");
        Resource O = A.createResource("jena:O");
        A.add(S, P, (RDFNode)O);
        B.add(S, P, (RDFNode)O);
        TestStatements.assertTrue((String)"X1", (boolean)A.isIsomorphicWith(B));
        A.add(R, RDF.subject, (RDFNode)S);
        B.add(R, RDF.predicate, (RDFNode)P);
        TestStatements.assertFalse((String)"X2", (boolean)A.isIsomorphicWith(B));
        A.add(R, RDF.predicate, (RDFNode)P);
        B.add(R, RDF.subject, (RDFNode)S);
        TestStatements.assertTrue((String)"X3", (boolean)A.isIsomorphicWith(B));
        A.add(R, RDF.object, (RDFNode)O);
        B.add(R, RDF.type, (RDFNode)RDF.Statement);
        TestStatements.assertFalse((String)"X4", (boolean)A.isIsomorphicWith(B));
        A.add(R, RDF.type, (RDFNode)RDF.Statement);
        B.add(R, RDF.object, (RDFNode)O);
        TestStatements.assertTrue((String)"X5", (boolean)A.isIsomorphicWith(B));
    }

    public void testSet() {
        Model A = ModelFactory.createDefaultModel();
        Model B = ModelFactory.createDefaultModel();
        Resource S = A.createResource("jena:S");
        Resource R = A.createResource("jena:R");
        Property P = A.createProperty("jena:P");
        Resource O = A.createResource("jena:O");
        Statement spo = A.createStatement(S, P, (RDFNode)O);
        A.add(spo);
        Statement sps = A.createStatement(S, P, (RDFNode)S);
        TestStatements.assertEquals((Object)sps, (Object)spo.changeObject((RDFNode)S));
        TestStatements.assertFalse((boolean)A.contains(spo));
        TestStatements.assertTrue((boolean)A.contains(sps));
    }

    public void testPortingBlankNodes() {
        Model A = ModelFactory.createDefaultModel();
        Model B = ModelFactory.createDefaultModel();
        Resource anon = A.createResource();
        Resource bAnon = (Resource)anon.inModel(B);
        TestStatements.assertTrue((String)"moved resource should still be blank", (boolean)bAnon.isAnon());
        TestStatements.assertEquals((String)"move resource should equal original", (Object)anon, (Object)bAnon);
    }

    public void testTripleWrapper() {
        Model A = ModelFactory.createDefaultModel();
        TestStatements.assertInstanceOf(FrontsTriple.class, TestStatements.statement(A, "s p o"));
    }

    public void testStatementPrintsType() {
        Literal O;
        Property P;
        Model m = ModelFactory.createDefaultModel();
        String fakeURI = "fake:URI";
        Resource S = m.createResource();
        Statement st = m.createStatement(S, P = TestStatements.property(m, "PP"), (RDFNode)(O = m.createTypedLiteral("42", fakeURI)));
        TestStatements.assertTrue((st.toString().indexOf(fakeURI) > 0 ? 1 : 0) != 0);
    }
}

