/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.n3.RelURI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestModelRead
extends ModelTestBase {
    public TestModelRead(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelRead.class);
    }

    public void testReturnsSelf() {
        Model m = ModelFactory.createDefaultModel();
        TestModelRead.assertSame((Object)m, (Object)m.read("file:testing/modelReading/empty.n3", "base", "N3"));
        TestModelRead.assertTrue((boolean)m.isEmpty());
    }

    public void testLoadsSimpleModel() {
        Model expected = ModelFactory.createDefaultModel();
        Model m = ModelFactory.createDefaultModel();
        expected.read("file:testing/modelReading/simple.n3", "N3");
        TestModelRead.assertSame((Object)m, (Object)m.read("file:testing/modelReading/simple.n3", "base", "N3"));
        TestModelRead.assertIsoModels(expected, m);
    }

    public void testSimpleLoadImplictBase() {
        Model mBasedImplicit = ModelFactory.createDefaultModel();
        String fn = RelURI.resolveFileURL((String)"file:testing/modelReading/based.n3");
        Model wanted = ModelFactory.createDefaultModel().add(TestModelRead.resource(fn), TestModelRead.property("jms:predicate"), (RDFNode)TestModelRead.resource("jms:object"));
        mBasedImplicit.read(fn, "N3");
        TestModelRead.assertIsoModels(wanted, mBasedImplicit);
    }

    public void testSimpleLoadExplicitBase() {
        Model mBasedExplicit = ModelFactory.createDefaultModel();
        mBasedExplicit.read("file:testing/modelReading/based.n3", "http://example/", "N3");
        TestModelRead.assertIsoModels(TestModelRead.modelWithStatements("http://example/ jms:predicate jms:object"), mBasedExplicit);
    }

    public void testDefaultLangXML() {
        Model m = ModelFactory.createDefaultModel();
        m.read("file:testing/modelReading/plain.rdf", null, null);
    }
}

