/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.rdf.arp.test.NTripleTestSuite;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ARPTests {
    public static boolean internet = false;
    static IRI wgTestDir = IRIFactory.iriImplementation().create("http://www.w3.org/2000/10/rdf-tests/rdfcore/");
    static IRI arpTestDir = IRIFactory.iriImplementation().create("http://jcarroll.hpl.hp.com/arp-tests/");
    static int cnt = 0;

    public static Test suite() {
        TestSuite s = new TestSuite("ARP");
        if (internet) {
            s.addTest((Test)NTripleTestSuite.suite(wgTestDir, wgTestDir.toString(), "WG Parser Tests"));
        } else {
            s.addTest((Test)WGTestSuite.suite(wgTestDir, "wg", "WG Parser Tests"));
            s.addTest((Test)WGTestSuite.suite(arpTestDir, "arp", "ARP Tests"));
            s.addTest((Test)NTripleTestSuite.suite(wgTestDir, "wg", "NTriple WG Tests"));
        }
        return s;
    }

    static String toJava(Test s, PrintWriter pw, String wgparent) {
        String name = "test" + cnt++;
        if (s instanceof TestSuite) {
            TestSuite ts = (TestSuite)s;
            if (s instanceof WGTestSuite) {
                pw.println("WGTestSuite " + name + " = " + ((WGTestSuite)s).createMe + ";");
                wgparent = name;
            } else {
                pw.println("TestSuite " + name + " = new TestSuite(\"" + ts.getName() + "\");");
            }
            Enumeration ee = ts.tests();
            while (ee.hasMoreElements()) {
                Test tt = (Test)ee.nextElement();
                if (tt == null) continue;
                String sub = ARPTests.toJava(tt, pw, wgparent);
                pw.println(name + ".addTest(" + sub + ");");
            }
        } else if (s instanceof WGTestSuite.Test) {
            String className = s.getClass().getName();
            String localPart = className.substring(className.lastIndexOf(36) + 1);
            pw.println("Test " + name + " = " + wgparent + ".create" + localPart + "(" + ((WGTestSuite.Test)s).createMe() + ");");
        } else {
            pw.println(name + " is of class " + s.getClass().getName());
        }
        return name;
    }

    public static void main(String[] args) throws IOException {
        Test ts = ARPTests.suite();
        PrintWriter pw = new PrintWriter(new FileWriter("src/com/hp/hpl/jena/rdf/arp/test/TestPackage.java"));
        pw.println("/*");
        pw.println(" *  (c) Copyright 2002-2002, 2003, 2004, 2005, 2006 Hewlett-Packard Development Company, LP");
        pw.println(" *  All rights reserved.");
        pw.println(" *");
        pw.println(" * Redistribution and use in source and binary forms, with or without");
        pw.println(" * modification, are permitted provided that the following conditions");
        pw.println(" * are met:");
        pw.println(" * 1. Redistributions of source code must retain the above copyright");
        pw.println(" *    notice, this list of conditions and the following disclaimer.");
        pw.println(" * 2. Redistributions in binary form must reproduce the above copyright");
        pw.println(" *    notice, this list of conditions and the following disclaimer in the");
        pw.println(" *    documentation and/or other materials provided with the distribution.");
        pw.println(" * 3. The name of the author may not be used to endorse or promote products");
        pw.println(" *    derived from this software without specific prior written permission.");
        pw.println("");
        pw.println(" * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR");
        pw.println(" * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES");
        pw.println(" * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.");
        pw.println(" * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,");
        pw.println(" * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT");
        pw.println(" * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,");
        pw.println(" * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY");
        pw.println(" * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT");
        pw.println(" * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF");
        pw.println(" * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
        pw.println(" *");
        pw.println(" */");
        pw.println("package com.hp.hpl.jena.rdf.arp.test;");
        pw.println("import junit.framework.TestSuite;");
        pw.println("import junit.framework.Test;");
        pw.println("import com.hp.hpl.jena.shared.wg.*;");
        pw.println("public class TestPackage{");
        pw.println("static public Test suite() {");
        String tsname = ARPTests.toJava(ts, pw, "xx");
        pw.println("return " + tsname + ";");
        pw.println("} }");
        pw.println("");
        pw.flush();
    }
}

